/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameCalendarResource
extends AdminDocumentHandler {
    private static final String[] TARGET_RESOURCE_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedResourcePath() {
        return TARGET_RESOURCE_PATH;
    }

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = RenameCalendarResource.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String id = request.getAttribute("id");
        String newName = request.getAttribute("newName");
        CalendarResource resource = prov.get(Provisioning.CalendarResourceBy.id, id);
        if (resource == null) {
            throw AccountServiceException.NO_SUCH_CALENDAR_RESOURCE(id);
        }
        String oldName = resource.getName();
        this.checkAccountRight(zsc, resource, Rights.Admin.R_renameCalendarResource);
        this.checkDomainRightByEmail(zsc, newName, Rights.Admin.R_createCalendarResource);
        prov.renameCalendarResource(id, newName);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "RenameCalendarResource", "name", oldName, "newName", newName}));
        resource = prov.get(Provisioning.CalendarResourceBy.id, id);
        if (resource == null) {
            throw ServiceException.FAILURE("unable to get calendar resource after rename: " + id, null);
        }
        Element response = zsc.createElement(AdminConstants.RENAME_CALENDAR_RESOURCE_RESPONSE);
        ToXML.encodeCalendarResource(response, resource, true);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_renameCalendarResource);
        relatedRights.add(Rights.Admin.R_createCalendarResource);
    }
}

