/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveDistributionListMember
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = RemoveDistributionListMember.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String id = request.getAttribute("id");
        LinkedList<String> memberList = new LinkedList<String>();
        for (Element elem : request.listElements("dlm")) {
            memberList.add(elem.getTextTrim());
        }
        DistributionList dl = prov.get(Provisioning.DistributionListBy.id, id);
        if (dl == null) {
            throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(id);
        }
        this.checkDistributionListRight(zsc, dl, Rights.Admin.R_removeDistributionListMember);
        Object[] members = memberList.toArray(new String[0]);
        prov.removeMembers(dl, (String[])members);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "RemoveDistributionListMember", "name", dl.getName(), "member", Arrays.deepToString(members)}));
        Element response = zsc.createElement(AdminConstants.REMOVE_DISTRIBUTION_LIST_MEMBER_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_removeDistributionListMember);
    }
}

