/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveDistributionListAlias
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = RemoveDistributionListAlias.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String id = request.getAttribute("id", null);
        String alias = request.getAttribute("alias");
        DistributionList dl = null;
        if (id != null) {
            dl = prov.get(Provisioning.DistributionListBy.id, id);
        }
        String dlName = "";
        if (dl != null) {
            this.checkDistributionListRight(zsc, dl, Rights.Admin.R_removeDistributionListAlias);
            dlName = dl.getName();
        }
        this.checkDomainRightByEmail(zsc, alias, Rights.Admin.R_deleteAlias);
        prov.removeAlias(dl, alias);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "RemoveDistributionListAlias", "name", dlName, "alias", alias}));
        Element response = zsc.createElement(AdminConstants.REMOVE_DISTRIBUTION_LIST_ALIAS_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_removeDistributionListAlias);
        relatedRights.add(Rights.Admin.R_deleteAlias);
    }
}

