/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AddAccountLogger;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveAccountLogger
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = RemoveAccountLogger.getZimbraSoapContext(context);
        Server localServer = Provisioning.getInstance().getLocalServer();
        this.checkRight(zsc, context, localServer, Rights.Admin.R_manageAccountLogger);
        Account account = null;
        String accountName = null;
        if (request.getOptionalElement("id") != null || request.getOptionalElement("account") != null) {
            account = AddAccountLogger.getAccountFromLoggerRequest(request);
            accountName = account.getName();
        }
        Element eLogger = request.getOptionalElement("logger");
        String category = null;
        if (eLogger != null && !LogFactory.logExists(category = eLogger.getAttribute("category"))) {
            throw ServiceException.INVALID_REQUEST("Log category " + category + " does not exist.", null);
        }
        for (Log log : LogFactory.getAllLoggers()) {
            if (category != null && !log.getCategory().equals(category)) continue;
            if (accountName != null) {
                boolean removed = log.removeAccountLogger(accountName);
                if (!removed) continue;
                ZimbraLog.misc.info("Removed logger for account %s from category %s.", accountName, log.getCategory());
                continue;
            }
            int count = log.removeAccountLoggers();
            if (count <= 0) continue;
            ZimbraLog.misc.info("Removed %d custom loggers from category %s.", count, log.getCategory());
        }
        Element response = zsc.createElement(AdminConstants.REMOVE_ACCOUNT_LOGGER_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_manageAccountLogger);
    }
}

