/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecalculateMailboxCounts
extends AdminDocumentHandler {
    private static final String[] TARGET_ACCOUNT_PATH = new String[]{"mbox", "id"};

    @Override
    protected String[] getProxiedAccountPath() {
        return TARGET_ACCOUNT_PATH;
    }

    @Override
    protected Element proxyIfNecessary(Element request, Map<String, Object> context) throws ServiceException {
        Account acct;
        String acctId;
        ZimbraSoapContext zsc = RecalculateMailboxCounts.getZimbraSoapContext(context);
        if (zsc.getProxyTarget() != null) {
            return null;
        }
        Provisioning prov = Provisioning.getInstance();
        String[] xpath = this.getProxiedAccountPath();
        String string = acctId = xpath != null ? RecalculateMailboxCounts.getXPath(request, xpath) : null;
        if (acctId != null && (acct = this.getAccount(prov, Provisioning.AccountBy.id, acctId, zsc.getAuthToken())) != null && !Provisioning.onLocalServer(acct)) {
            return this.proxyRequest(request, context, acctId);
        }
        return null;
    }

    @Override
    public boolean domainAuthSufficient(Map<String, Object> context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = RecalculateMailboxCounts.getZimbraSoapContext(context);
        Element mreq = request.getElement("mbox");
        String accountId = mreq.getAttribute("id");
        Account account = Provisioning.getInstance().get(Provisioning.AccountBy.id, accountId, zsc.getAuthToken());
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(accountId);
        }
        this.checkAccountRight(zsc, account, Rights.Admin.R_adminLoginAs);
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account, false);
        if (mbox == null) {
            throw ServiceException.FAILURE("mailbox not found for account " + accountId, null);
        }
        mbox.recalculateFolderAndTagCounts();
        Element response = zsc.createElement(AdminConstants.RECALCULATE_MAILBOX_COUNTS_RESPONSE);
        Element mboxElem = response.addElement("mbox");
        mboxElem.addAttribute("id", accountId);
        mboxElem.addAttribute("used", mbox.getSize());
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_adminLoginAs);
    }
}

