/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReIndex
extends AdminDocumentHandler {
    private final String ACTION_START = "start";
    private final String ACTION_STATUS = "status";
    private final String ACTION_CANCEL = "cancel";
    private static final String[] TARGET_ACCOUNT_PATH = new String[]{"mbox", "id"};

    @Override
    protected String[] getProxiedAccountPath() {
        return TARGET_ACCOUNT_PATH;
    }

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = ReIndex.getZimbraSoapContext(context);
        String action = request.getAttribute("action");
        Element mreq = request.getElement("mbox");
        String accountId = mreq.getAttribute("id");
        Account account = Provisioning.getInstance().get(Provisioning.AccountBy.id, accountId, zsc.getAuthToken());
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(accountId);
        }
        this.checkAccountRight(zsc, account, Rights.Admin.R_reindexMailbox);
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account, false);
        if (mbox == null) {
            throw ServiceException.FAILURE("mailbox not found for account " + accountId, null);
        }
        Element response = zsc.createElement(AdminConstants.REINDEX_RESPONSE);
        if (action.equalsIgnoreCase("start")) {
            HashSet<Byte> typesSet;
            if (mbox.isReIndexInProgress()) {
                throw ServiceException.ALREADY_IN_PROGRESS(accountId, "ReIndex");
            }
            byte[] types = null;
            String typesStr = mreq.getAttribute("types", null);
            if (typesStr != null) {
                types = MailboxIndex.parseTypesString(typesStr);
            }
            HashSet<Integer> itemIds = null;
            String idsStr = mreq.getAttribute("ids", null);
            if (idsStr != null) {
                String[] targets;
                itemIds = new HashSet<Integer>();
                for (String target : targets = idsStr.split(",")) {
                    itemIds.add(Integer.parseInt(target));
                }
            }
            if (types == null) {
                typesSet = null;
            } else {
                typesSet = new HashSet<Byte>();
                for (byte b : types) {
                    typesSet.add(b);
                }
            }
            mbox.reIndex(ReIndex.getOperationContext(zsc, context), typesSet, itemIds, false);
            response.addAttribute("status", "started");
        } else if (action.equalsIgnoreCase("status")) {
            Mailbox mailbox = mbox;
            synchronized (mailbox) {
                if (!mbox.isReIndexInProgress()) {
                    throw ServiceException.NOT_IN_PROGRESS(accountId, "ReIndex");
                }
                Mailbox.BatchedIndexStatus status = mbox.getReIndexStatus();
                ReIndex.addStatus(response, status);
            }
            response.addAttribute("status", "running");
        } else if (action.equalsIgnoreCase("cancel")) {
            Mailbox mailbox = mbox;
            synchronized (mailbox) {
                if (!mbox.isReIndexInProgress()) {
                    throw ServiceException.NOT_IN_PROGRESS(accountId, "ReIndex");
                }
                Mailbox.BatchedIndexStatus status = mbox.getReIndexStatus();
                status.mCancel = true;
                response.addAttribute("status", "cancelled");
                ReIndex.addStatus(response, status);
            }
        } else {
            throw ServiceException.INVALID_REQUEST("Unknown action: " + action, null);
        }
        return response;
    }

    public static void addStatus(Element response, Mailbox.BatchedIndexStatus status) {
        Element prog = response.addElement("progress");
        prog.addAttribute("numSucceeded", status.mNumProcessed - status.mNumFailed);
        prog.addAttribute("numFailed", status.mNumFailed);
        prog.addAttribute("numRemaining", status.mNumToProcess - status.mNumProcessed);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_reindexMailbox);
    }
}

