/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.fb.FreeBusyProvider;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushFreeBusy
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = PushFreeBusy.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Element domainElem = request.getOptionalElement("domain");
        if (domainElem == null) {
            Iterator<Element> accounts = request.elementIterator("account");
            while (accounts.hasNext()) {
                String accountId = accounts.next().getAttribute("id", null);
                if (accountId == null) continue;
                Account acct = prov.get(Provisioning.AccountBy.id, accountId, zsc.getAuthToken());
                if (acct == null) {
                    ZimbraLog.misc.warn("invalid accountId: " + accountId);
                    continue;
                }
                if (!Provisioning.onLocalServer(acct)) {
                    ZimbraLog.misc.warn("account is not on this server: " + accountId);
                    continue;
                }
                this.checkAccountRight(zsc, acct, Rights.Admin.R_adminLoginAs);
                FreeBusyProvider.mailboxChanged(accountId);
            }
        } else {
            String[] domains = domainElem.getAttribute("name").split(",");
            Server s = prov.getLocalServer();
            PushFreeBusyVisitor visitor = new PushFreeBusyVisitor(zsc, this);
            for (String domain : domains) {
                Domain d = prov.get(Provisioning.DomainBy.name, domain);
                prov.getAllAccounts(d, s, visitor);
            }
        }
        Element response = zsc.createElement(AdminConstants.PUSH_FREE_BUSY_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_adminLoginAs);
    }

    private static class PushFreeBusyVisitor
    implements NamedEntry.Visitor {
        ZimbraSoapContext mZsc;
        AdminDocumentHandler mHandler;

        PushFreeBusyVisitor(ZimbraSoapContext zsc, AdminDocumentHandler handler) {
            this.mZsc = zsc;
            this.mHandler = handler;
        }

        public void visit(NamedEntry entry) throws ServiceException {
            Account acct;
            String[] fps;
            if (entry instanceof Account && (fps = (acct = (Account)entry).getForeignPrincipal()) != null && fps.length > 0) {
                for (String fp : fps) {
                    int idx;
                    if (!fp.startsWith("ad:") || (idx = fp.indexOf(58)) == -1) continue;
                    this.mHandler.checkAccountRight(this.mZsc, acct, Rights.Admin.R_adminLoginAs);
                    FreeBusyProvider.mailboxChanged(acct.getId());
                    break;
                }
            }
        }
    }
}

