/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgeMessages
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String[] accounts;
        ZimbraSoapContext zsc = PurgeMessages.getZimbraSoapContext(context);
        Element mreq = request.getOptionalElement("mbox");
        if (mreq != null) {
            accounts = new String[]{mreq.getAttribute("id")};
            Provisioning prov = Provisioning.getInstance();
            for (String acctId : accounts) {
                Account acct = prov.get(Provisioning.AccountBy.id, acctId);
                if (acct == null) {
                    throw AccountServiceException.NO_SUCH_ACCOUNT(acctId);
                }
                this.checkAccountRight(zsc, acct, Rights.Admin.R_purgeMessages);
            }
        } else {
            this.checkRight(zsc, context, null, AdminRight.PR_SYSTEM_ADMIN_ONLY);
            accounts = MailboxManager.getInstance().getAccountIds();
        }
        Element response = zsc.createElement(AdminConstants.PURGE_MESSAGES_RESPONSE);
        for (int i = 0; i < accounts.length; ++i) {
            Mailbox mbox;
            block8: {
                mbox = null;
                try {
                    mbox = MailboxManager.getInstance().getMailboxByAccountId(accounts[i]);
                    mbox.purgeMessages(null);
                }
                catch (ServiceException e) {
                    if (e.getCode() == "service.WRONG_HOST") {
                        ZimbraLog.mailbox.warn((Object)("ignoring mailbox found on wrong host (not cleaned up after migrate?): " + accounts[i]), e);
                    }
                    if (e.getCode() == "account.NO_SUCH_ACCOUNT") break block8;
                    throw e;
                }
            }
            if (mbox == null) continue;
            Element mresp = response.addElement("mbox");
            mresp.addAttribute("mbxid", mbox.getId());
            mresp.addAttribute("s", mbox.getSize());
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_purgeMessages);
        notes.add("If account ids are specified, needs effective " + Rights.Admin.R_purgeMessages.getName() + " right for each account.  " + "If account ids are not specified, the authed account has to be a system admin.");
    }
}

