/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.calendar.cache.CalendarCacheManager;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgeAccountCalendarCache
extends AdminDocumentHandler {
    private static final String[] TARGET_ACCOUNT_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedAccountPath() {
        return TARGET_ACCOUNT_PATH;
    }

    @Override
    public boolean domainAuthSufficient(Map<String, Object> context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String id;
        ZimbraSoapContext zsc = PurgeAccountCalendarCache.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.id, id = request.getAttribute("id"), zsc.getAuthToken());
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(id);
        }
        if (account.isCalendarResource()) {
            CalendarResource resource = prov.get(Provisioning.CalendarResourceBy.id, id);
            this.checkCalendarResourceRight(zsc, resource, Rights.Admin.R_purgeCalendarResourceCalendarCache);
        } else {
            this.checkAccountRight(zsc, account, Rights.Admin.R_purgeAccountCalendarCache);
        }
        if (!Provisioning.onLocalServer(account)) {
            throw ServiceException.WRONG_HOST(account.getAttr("zimbraMailHost"), null);
        }
        CalendarCacheManager calCache = CalendarCacheManager.getInstance();
        ZimbraLog.calendar.info("Purging calendar cache for account " + account.getName());
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account, false);
        if (mbox != null) {
            calCache.purgeMailbox(mbox);
        }
        Element response = zsc.createElement(AdminConstants.PURGE_ACCOUNT_CALENDAR_CACHE_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_purgeAccountCalendarCache);
        relatedRights.add(Rights.Admin.R_purgeCalendarResourceCalendarCache);
    }
}

