/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ShareInfo;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.admin.ShareInfoHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishShareInfo
extends ShareInfoHandler {
    private static final String[] OWNER_ACCOUNT_PATH = new String[]{"share", "owner"};

    @Override
    protected String[] getProxiedAccountElementPath() {
        return OWNER_ACCOUNT_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = PublishShareInfo.getZimbraSoapContext(context);
        OperationContext octxt = PublishShareInfo.getOperationContext(zsc, context);
        Provisioning prov = Provisioning.getInstance();
        NamedEntry publishingOnEntry = this.getPublishableTargetEntry(zsc, request, prov);
        Element eShare = request.getElement("share");
        Provisioning.PublishShareInfoAction action = Provisioning.PublishShareInfoAction.fromString(eShare.getAttribute("action"));
        this.checkDistributionListRight(zsc, (DistributionList)publishingOnEntry, Rights.Admin.R_publishDistributionListShareInfo);
        Element eFolder = eShare.getElement("folder");
        String folderPath = eFolder.getAttribute("path", null);
        String folderId = eFolder.getAttribute("l", null);
        String folderIdOrPath = eFolder.getAttribute("pathOrId", null);
        if (folderPath != null) {
            this.ensureOtherFolderDescriptorsAreNotPresent(folderId, folderIdOrPath);
        } else if (folderId != null) {
            this.ensureOtherFolderDescriptorsAreNotPresent(folderPath, folderIdOrPath);
        } else if (folderIdOrPath != null) {
            this.ensureOtherFolderDescriptorsAreNotPresent(folderPath, folderId);
        }
        if (action == Provisioning.PublishShareInfoAction.add) {
            Account ownerAcct = this.getOwner(zsc, eShare, prov, true);
            this.checkAccountRight(zsc, ownerAcct, Rights.Admin.R_adminLoginAs);
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(ownerAcct, false);
            if (mbox == null) {
                throw ServiceException.FAILURE("mailbox not found for account " + ownerAcct.getId(), null);
            }
            Folder folder = null;
            folder = folderPath != null ? this.getFolderByPath(octxt, mbox, folderPath) : (folderId != null ? this.getFolderByPath(octxt, mbox, folderId) : (folderIdOrPath != null ? this.getFolder(octxt, mbox, folderIdOrPath) : null));
            ShareInfo.Publishing.publish(prov, octxt, publishingOnEntry, ownerAcct, folder);
        } else {
            boolean allOwners = false;
            String ownerAcctId = null;
            String ownerAcctEmail = null;
            Element eOwner = eShare.getOptionalElement("owner");
            if (eOwner == null) {
                allOwners = true;
            } else {
                allOwners = false;
                String key = eOwner.getAttribute("by");
                Provisioning.AccountBy by = Provisioning.AccountBy.fromString(key);
                if (by == Provisioning.AccountBy.id) {
                    ownerAcctId = eOwner.getText();
                } else if (by == Provisioning.AccountBy.name) {
                    ownerAcctEmail = eOwner.getText();
                } else {
                    throw ServiceException.INVALID_REQUEST("invalid owner key: " + key, null);
                }
            }
            if (folderIdOrPath != null) {
                if (folderIdOrPath.charAt(0) == '/') {
                    folderPath = folderIdOrPath;
                } else {
                    folderId = folderIdOrPath;
                }
            }
            boolean allFolders = folderId == null && folderPath == null;
            ShareInfo.Published.unpublish(prov, (DistributionList)publishingOnEntry, ownerAcctId, ownerAcctEmail, allOwners, folderId, folderPath, allFolders);
        }
        Element response = zsc.createElement(AdminConstants.PUBLISH_SHARE_INFO_RESPONSE);
        return response;
    }

    private Folder getFolder(OperationContext octxt, Mailbox mbox, String folderIdOrPath) throws ServiceException {
        try {
            return this.getFolderByPath(octxt, mbox, folderIdOrPath);
        }
        catch (MailServiceException e) {
            if ("mail.NO_SUCH_FOLDER".equals(e.getCode())) {
                return this.getFolderById(octxt, mbox, folderIdOrPath);
            }
            throw e;
        }
    }

    private Folder getFolderById(OperationContext octxt, Mailbox mbox, String folderId) throws ServiceException {
        int fid;
        try {
            fid = Integer.parseInt(folderId);
        }
        catch (NumberFormatException e) {
            throw MailServiceException.NO_SUCH_FOLDER(folderId);
        }
        Folder folder = mbox.getFolderById(octxt, fid);
        if (folder == null) {
            throw MailServiceException.NO_SUCH_FOLDER(folderId);
        }
        return folder;
    }

    private Folder getFolderByPath(OperationContext octxt, Mailbox mbox, String folderPath) throws ServiceException {
        Folder folder = mbox.getFolderByPath(octxt, folderPath);
        if (folder == null) {
            throw MailServiceException.NO_SUCH_FOLDER(folderPath);
        }
        return folder;
    }

    private void ensureOtherFolderDescriptorsAreNotPresent(String other1, String other2) throws ServiceException {
        if (other1 != null || other2 != null) {
            throw ServiceException.INVALID_REQUEST("can only specify one of path or lpathOrId", null);
        }
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_adminLoginAs);
        relatedRights.add(Rights.Admin.R_publishDistributionListShareInfo);
        notes.add("Needs the " + Rights.Admin.R_publishDistributionListShareInfo.getName() + " right on the distribution list entry to publish; and the " + Rights.Admin.R_adminLoginAs.getName() + " right on the owner account.");
    }
}

