/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.zimlet.ZimletException;
import com.zimbra.cs.zimlet.ZimletUtil;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyZimlet
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Element p;
        Element s;
        ZimbraSoapContext zsc = ModifyZimlet.getZimbraSoapContext(context);
        Element z = request.getElement("zimlet");
        Element a = z.getOptionalElement("acl");
        if (a != null) {
            this.doAcl(zsc, context, z);
        }
        if ((s = z.getOptionalElement("status")) != null) {
            this.doStatus(zsc, context, z);
        }
        if ((p = z.getOptionalElement("priority")) != null) {
            this.doPriority(zsc, context, z);
        }
        Element response = zsc.createElement(AdminConstants.MODIFY_ZIMLET_RESPONSE);
        return response;
    }

    void doAcl(ZimbraSoapContext zsc, Map<String, Object> context, Element z) throws ServiceException {
        block7: {
            String name = z.getAttribute("name");
            Element a = z.getElement("acl");
            String cosName = a.getAttribute("cos", null);
            if (cosName == null) {
                return;
            }
            Cos cos = Provisioning.getInstance().get(Provisioning.CosBy.name, cosName);
            if (cos == null) {
                throw AccountServiceException.NO_SUCH_COS(cosName);
            }
            this.checkRight(zsc, context, cos, Rights.Admin.R_manageZimlet);
            String acl = a.getAttribute("acl", null);
            if (acl == null) {
                throw ServiceException.INVALID_REQUEST("missing acl attribute", null);
            }
            acl = acl.toLowerCase();
            try {
                if (acl.equals("grant")) {
                    ZimletUtil.activateZimlet(name, cosName);
                    break block7;
                }
                if (acl.equals("deny")) {
                    ZimletUtil.deactivateZimlet(name, cosName);
                    break block7;
                }
                throw ServiceException.INVALID_REQUEST("invalid acl setting " + acl, null);
            }
            catch (ZimletException ze) {
                throw ServiceException.FAILURE("cannot modify acl", ze);
            }
        }
    }

    void doStatus(ZimbraSoapContext zsc, Map<String, Object> context, Element z) throws ServiceException {
        String name = z.getAttribute("name");
        Zimlet zimlet = Provisioning.getInstance().getZimlet(name);
        if (z == null) {
            throw AccountServiceException.NO_SUCH_ZIMLET(name);
        }
        Element s = z.getElement("status");
        String val = s.getAttribute("value", null);
        if (val == null) {
            return;
        }
        boolean status = val.equalsIgnoreCase("enabled");
        HashMap<String, String> attrRightNeeded = new HashMap<String, String>();
        attrRightNeeded.put("zimbraZimletEnabled", status ? "TRUE" : "FALSE");
        this.checkRight(zsc, context, zimlet, attrRightNeeded);
        try {
            ZimletUtil.setZimletEnable(name, status);
        }
        catch (ZimletException ze) {
            throw ServiceException.FAILURE("cannot modify status", ze);
        }
    }

    void doPriority(ZimbraSoapContext zsc, Map<String, Object> context, Element z) throws ServiceException {
        String name = z.getAttribute("name");
        Zimlet zimlet = Provisioning.getInstance().getZimlet(name);
        if (zimlet == null) {
            throw AccountServiceException.NO_SUCH_ZIMLET(name);
        }
        Element p = z.getElement("priority");
        int val = (int)p.getAttributeLong("value", -1L);
        if (val == -1) {
            return;
        }
        HashMap<String, Object> attrRightNeeded = new HashMap<String, Object>();
        attrRightNeeded.put("zimbraZimletPriority", null);
        List<Zimlet> allZimlets = Provisioning.getInstance().listAllZimlets();
        for (Zimlet zl : allZimlets) {
            this.checkRight(zsc, context, zl, attrRightNeeded);
        }
        ZimletUtil.setPriority(name, val);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_manageZimlet);
        relatedRights.add(Rights.Admin.R_modifyZimlet);
        notes.add("For acl: needs " + Rights.Admin.R_manageZimlet.getName() + " on cos.");
        notes.add("For status: needs right to set zimbraZimletEnabled on the zimlet");
        notes.add("For priority: needs right to set zimbraZimletPriority on *all* zimlets, because potentially the attribute can be modified on all zimlets.");
    }
}

