/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.AdminService;
import com.zimbra.cs.service.admin.GetServer;
import com.zimbra.cs.util.Config;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyServer
extends AdminDocumentHandler {
    private static final String[] TARGET_SERVER_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedServerPath() {
        return TARGET_SERVER_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Server localServer;
        ZimbraSoapContext zsc = ModifyServer.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String id = request.getAttribute("id");
        Map<String, Object> attrs = AdminService.getAttrs(request);
        Server server = prov.get(Provisioning.ServerBy.id, id);
        if (server == null) {
            throw AccountServiceException.NO_SUCH_SERVER(id);
        }
        this.checkRight(zsc, context, server, attrs);
        prov.modifyAttrs(server, attrs, true);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "ModifyServer", "name", server.getName()}, attrs));
        if (attrs.containsKey("zimbraUserServicesEnabled") && server.equals(localServer = Provisioning.getInstance().getLocalServer())) {
            Config.enableUserServices(server.getBooleanAttr("zimbraUserServicesEnabled", true));
        }
        Element response = zsc.createElement(AdminConstants.MODIFY_SERVER_RESPONSE);
        GetServer.encodeServer(response, server);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add(String.format("All attrs provided in the attribute list have to settable by. the authed admin.   You can grant the %s right, which allows setting all attributes on %s, or grant the set attrs right just for the attributes the admin needs to set while creating an entry.", Rights.Admin.R_modifyServer.getName(), "server"));
    }
}

