/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.AdminService;
import com.zimbra.cs.service.admin.GetDomain;
import com.zimbra.cs.service.admin.ModifyAccount;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDomain
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = ModifyDomain.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String id = request.getAttribute("id");
        Map<String, Object> attrs = AdminService.getAttrs(request);
        Domain domain = prov.get(Provisioning.DomainBy.id, id);
        if (domain == null) {
            throw AccountServiceException.NO_SUCH_DOMAIN(id);
        }
        if (domain.isShutdown()) {
            throw ServiceException.PERM_DENIED("can not access domain, domain is in " + domain.getDomainStatusAsString() + " status");
        }
        this.checkDomainRight(zsc, domain, attrs);
        this.checkCos(zsc, attrs);
        prov.modifyAttrs(domain, attrs, true);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "ModifyDomain", "name", domain.getName()}, attrs));
        Element response = zsc.createElement(AdminConstants.MODIFY_DOMAIN_RESPONSE);
        GetDomain.encodeDomain(response, domain);
        return response;
    }

    private void checkCos(ZimbraSoapContext zsc, Map<String, Object> attrs) throws ServiceException {
        String newDomainCosId = ModifyAccount.getStringAttrNewValue("zimbraDomainDefaultCOSId", attrs);
        if (newDomainCosId == null) {
            return;
        }
        Provisioning prov = Provisioning.getInstance();
        if (newDomainCosId.equals("")) {
            return;
        }
        Cos cos = prov.get(Provisioning.CosBy.id, newDomainCosId);
        if (cos == null) {
            throw AccountServiceException.NO_SUCH_COS(newDomainCosId);
        }
        ModifyDomain.checkRight(zsc, cos, Rights.Admin.R_assignCos);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add(String.format("All attrs provided in the attribute list have to settable by. the authed admin.   You can grant the %s right, which allows setting all attributes on %s, or grant the set attrs right just for the attributes the admin needs to set while creating an entry.", Rights.Admin.R_modifyDomain.getName(), "domain"));
        notes.add("Notes on zimbraDomainDefaultCOSId: If setting zimbraDomainDefaultCOSId, needs the " + Rights.Admin.R_assignCos.getName() + " right on the cos.");
    }
}

