/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.AttributeConstraint;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.GetDelegatedAdminConstraints;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDelegatedAdminConstraints
extends AdminDocumentHandler {
    private static final String CONSTRAINT_ATTR = "zimbraConstraint";

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = ModifyDelegatedAdminConstraints.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Entry entry = GetDelegatedAdminConstraints.getEntry(request);
        AdminAccessControl.SetAttrsRight sar = new AdminAccessControl.SetAttrsRight();
        sar.addAttr(CONSTRAINT_ATTR);
        this.checkRight(zsc, context, entry, sar);
        AttributeManager am = AttributeManager.getInstance();
        ArrayList<AttributeConstraint> constraints = new ArrayList<AttributeConstraint>();
        for (Element a : request.listElements("a")) {
            String attrName = a.getAttribute("name");
            Element eConstraint = a.getElement("constraint");
            constraints.add(AttributeConstraint.fromXML(am, attrName, eConstraint));
        }
        AttributeConstraint.modifyConstraint(entry, constraints);
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put(CONSTRAINT_ATTR, entry.getMultiAttr(CONSTRAINT_ATTR, false));
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "ModifyDelegatedAdminConstraints", "name", entry.getLabel()}, attrs));
        Element response = zsc.createElement(AdminConstants.MODIFY_DELEGATED_ADMIN_CONSTRAINTS_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Need set attr right on attribute zimbraConstraint");
    }
}

