/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.AdminService;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDataSource
extends AdminDocumentHandler {
    private static final String[] TARGET_ACCOUNT_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedAccountPath() {
        return TARGET_ACCOUNT_PATH;
    }

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        String id;
        ZimbraSoapContext zsc = ModifyDataSource.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.id, id = request.getAttribute("id"), zsc.getAuthToken());
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(id);
        }
        this.checkAccountRight(zsc, account, Rights.Admin.R_adminLoginAs);
        Element dsEl = request.getElement("dataSource");
        Map<String, Object> attrs = AdminService.getAttrs(dsEl);
        String dsId = dsEl.getAttribute("id");
        DataSource ds = prov.get(account, Provisioning.DataSourceBy.id, dsId);
        if (ds == null) {
            throw ServiceException.INVALID_REQUEST("Cannot find data source with id=" + dsId, null);
        }
        DataSource.Type type = ds.getType();
        if (this.isDomainAdminOnly(zsc)) {
            AttributeClass klass = ModifyDataSource.getAttributeClassFromType(type);
            this.checkModifyAttrs(zsc, klass, attrs);
        }
        ZimbraLog.addDataSourceNameToContext(ds.getName());
        prov.modifyDataSource(account, dsId, attrs);
        Element response = zsc.createElement(AdminConstants.MODIFY_DATA_SOURCE_RESPONSE);
        return response;
    }

    static AttributeClass getAttributeClassFromType(DataSource.Type type) {
        if (type == DataSource.Type.pop3) {
            return AttributeClass.pop3DataSource;
        }
        if (type == DataSource.Type.imap) {
            return AttributeClass.imapDataSource;
        }
        if (type == DataSource.Type.rss) {
            return AttributeClass.rssDataSource;
        }
        if (type == DataSource.Type.gal) {
            return AttributeClass.galDataSource;
        }
        return AttributeClass.dataSource;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_adminLoginAs);
    }
}

