/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.GetAdminSavedSearches;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyAdminSavedSearches
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = ModifyAdminSavedSearches.getZimbraSoapContext(context);
        Account acct = ModifyAdminSavedSearches.getRequestedAccount(zsc);
        this.checkAccountRight(zsc, acct, Rights.Admin.R_setAdminSavedSearch);
        Element response = zsc.createElement(AdminConstants.MODIFY_ADMIN_SAVED_SEARCHES_RESPONSE);
        HashMap<String, String> searches = null;
        Iterator<Element> it = request.elementIterator("search");
        while (it.hasNext()) {
            if (searches == null) {
                searches = new HashMap<String, String>();
            }
            Element e = it.next();
            String name = e.getAttribute("name");
            String query = e.getText();
            if (name != null && name.length() != 0) {
                searches.put(name, query);
                continue;
            }
            ZimbraLog.account.warn("ModifyAdminSavedSearches: empty search name ignored");
        }
        this.handle(acct, response, searches);
        return response;
    }

    public void handle(Account acct, Element response, HashMap<String, String> modSearches) throws ServiceException {
        String[] searches = acct.getMultiAttr("zimbraAdminSavedSearches");
        HashMap<String, GetAdminSavedSearches.AdminSearch> curSearches = new HashMap<String, GetAdminSavedSearches.AdminSearch>();
        for (int i = 0; i < searches.length; ++i) {
            GetAdminSavedSearches.AdminSearch as = GetAdminSavedSearches.AdminSearch.parse(searches[i]);
            curSearches.put(as.getName(), as);
        }
        for (Map.Entry<String, String> entry : modSearches.entrySet()) {
            String name = entry.getKey();
            String query = entry.getValue();
            GetAdminSavedSearches.AdminSearch mod = new GetAdminSavedSearches.AdminSearch(name, query);
            if (curSearches.containsKey(name)) {
                if (query.length() == 0) {
                    curSearches.remove(name);
                    continue;
                }
                curSearches.put(name, mod);
                continue;
            }
            if (query.length() == 0) {
                throw ServiceException.INVALID_REQUEST("query for " + name + " is empty", null);
            }
            curSearches.put(name, mod);
        }
        String[] mods = new String[curSearches.size()];
        int i = 0;
        for (GetAdminSavedSearches.AdminSearch m : curSearches.values()) {
            mods[i++] = m.encode();
        }
        Provisioning prov = Provisioning.getInstance();
        HashMap<String, String[]> modmap = new HashMap<String, String[]>();
        modmap.put("zimbraAdminSavedSearches", mods);
        prov.modifyAttrs(acct, modmap);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_setAdminSavedSearch);
    }
}

