/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.AdminService;
import com.zimbra.cs.service.admin.GetQuotaUsage;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.cs.session.AdminSession;
import com.zimbra.cs.session.Session;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyAccount
extends AdminDocumentHandler {
    private static final String[] TARGET_ACCOUNT_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedAccountPath() {
        return TARGET_ACCOUNT_PATH;
    }

    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        AdminSession session;
        ZimbraSoapContext zsc = ModifyAccount.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String id = request.getAttribute("id");
        Map<String, Object> attrs = AdminService.getAttrs(request);
        Account account = prov.get(Provisioning.AccountBy.id, id, zsc.getAuthToken());
        if (account == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(id);
        }
        this.checkAccountRight(zsc, account, attrs);
        long curQuota = account.getLongAttr("zimbraMailQuota", 0L);
        this.checkQuota(zsc, account, attrs);
        this.checkCos(zsc, account, attrs);
        prov.modifyAttrs(account, attrs, true);
        account = prov.get(Provisioning.AccountBy.id, id, zsc.getAuthToken());
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "ModifyAccount", "name", account.getName()}, attrs));
        this.checkNewServer(zsc, context, account);
        long newQuota = account.getLongAttr("zimbraMailQuota", 0L);
        if (newQuota != curQuota && (session = (AdminSession)this.getSession(zsc, Session.Type.ADMIN)) != null) {
            GetQuotaUsage.clearCachedQuotaUsage(session);
        }
        Element response = zsc.createElement(AdminConstants.MODIFY_ACCOUNT_RESPONSE);
        ToXML.encodeAccount(response, account);
        return response;
    }

    static String getStringAttrNewValue(String attrName, Map<String, Object> attrs) throws ServiceException {
        Object object = attrs.get(attrName);
        if (object == null) {
            object = attrs.get("+" + attrName);
        }
        if (object == null) {
            object = attrs.get("-" + attrName);
        }
        if (object == null) {
            return null;
        }
        if (!(object instanceof String)) {
            throw ServiceException.PERM_DENIED("can not modify " + attrName + "(single valued attribute)");
        }
        String attrNewValue = (String)object;
        return attrNewValue;
    }

    private void checkQuota(ZimbraSoapContext zsc, Account account, Map<String, Object> attrs) throws ServiceException {
        long quota;
        String quotaAttr = ModifyAccount.getStringAttrNewValue("zimbraMailQuota", attrs);
        if (quotaAttr == null) {
            return;
        }
        if (quotaAttr.equals("")) {
            quota = Provisioning.getInstance().getCOS(account).getIntAttr("zimbraMailQuota", 0);
        } else {
            try {
                quota = Long.parseLong(quotaAttr);
            }
            catch (NumberFormatException e) {
                throw AccountServiceException.INVALID_ATTR_VALUE("can not modify mail quota (invalid format): " + quotaAttr, e);
            }
        }
        if (!this.canModifyMailQuota(zsc, account, quota)) {
            throw ServiceException.PERM_DENIED("can not modify mail quota");
        }
    }

    private void checkCos(ZimbraSoapContext zsc, Account account, Map<String, Object> attrs) throws ServiceException {
        String newCosId = ModifyAccount.getStringAttrNewValue("zimbraCOSId", attrs);
        if (newCosId == null) {
            return;
        }
        Provisioning prov = Provisioning.getInstance();
        if (newCosId.equals("") && (newCosId = prov.getDomain(account).getAttr("zimbraDomainDefaultCOSId")) == null) {
            return;
        }
        Cos cos = prov.get(Provisioning.CosBy.id, newCosId);
        if (cos == null) {
            throw AccountServiceException.NO_SUCH_COS(newCosId);
        }
        ModifyAccount.checkRight(zsc, cos, Rights.Admin.R_assignCos);
    }

    private void checkNewServer(ZimbraSoapContext zsc, Map<String, Object> context, Account acct) {
        Server newServer = null;
        try {
            Provisioning.getInstance();
            if (!Provisioning.onLocalServer(acct)) {
                newServer = Provisioning.getInstance().getServer(acct);
                Element request = zsc.createRequestElement(AdminConstants.FLUSH_CACHE_REQUEST);
                Element eCache = request.addElement("cache").addAttribute("type", Provisioning.CacheEntryType.account.name());
                eCache.addElement("entry").addAttribute("by", Provisioning.CacheEntryBy.id.name()).addText(acct.getId());
                Element response = this.proxyRequest(request, context, newServer);
            }
        }
        catch (ServiceException e) {
            ZimbraLog.mailbox.warn((Object)("cannot flush account cache on server " + (newServer == null ? "" : newServer.getName()) + " for " + acct.getName()), e);
        }
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_assignCos);
        notes.add(String.format("All attrs provided in the attribute list have to settable by. the authed admin.   You can grant the %s right, which allows setting all attributes on %s, or grant the set attrs right just for the attributes the admin needs to set while creating an entry.", Rights.Admin.R_modifyAccount.getName(), "account") + "\n");
        notes.add("Notes on zimbraCOSId: If setting zimbraCOSId, needs the " + Rights.Admin.R_assignCos.getName() + " right on the cos." + "If removing " + "zimbraCOSId" + ", needs the " + Rights.Admin.R_assignCos.getName() + " right on the domain default cos. (in domain attribute " + "zimbraDomainDefaultCOSId" + ").");
    }
}

