/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.db.DbTableMaintenance;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaintainTables
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = MaintainTables.getZimbraSoapContext(context);
        this.checkRight(zsc, context, null, AdminRight.PR_SYSTEM_ADMIN_ONLY);
        int numTables = DbTableMaintenance.runMaintenance();
        Element response = zsc.createElement(AdminConstants.MAINTAIN_TABLES_RESPONSE);
        response.addAttribute("numTables", numTables);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Only system admins are allowed.");
    }
}

