/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.rmgmt.RemoteMailQueue;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.GetMailQueue;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailQueueAction
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String[] ids;
        Element serverElem;
        String serverName;
        ZimbraSoapContext zsc = MailQueueAction.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Server server = prov.get(Provisioning.ServerBy.name, serverName = (serverElem = request.getElement("server")).getAttribute("name"));
        if (server == null) {
            throw ServiceException.INVALID_REQUEST("server with name " + serverName + " could not be found", null);
        }
        this.checkRight(zsc, context, server, Rights.Admin.R_manageMailQueue);
        Element queueElem = serverElem.getElement("queue");
        String queueName = queueElem.getAttribute("name");
        RemoteMailQueue rmq = RemoteMailQueue.getRemoteMailQueue(server, queueName, false);
        Element actionElem = queueElem.getElement("action");
        String op = actionElem.getAttribute("op");
        RemoteMailQueue.QueueAction action = RemoteMailQueue.QueueAction.valueOf(op);
        if (action == null) {
            throw ServiceException.INVALID_REQUEST("bad op:" + op, null);
        }
        String by = actionElem.getAttribute("by");
        if (by.equals("id")) {
            String idText = actionElem.getText();
            ids = actionElem.getText().split(",");
        } else if (by.equals("query")) {
            Element queryElem = actionElem.getElement("query");
            Query query = GetMailQueue.buildLuceneQuery(queryElem);
            RemoteMailQueue.SearchResult sr = rmq.search(query, 0, 0);
            ids = new String[sr.qitems.size()];
            int i = 0;
            for (Map<RemoteMailQueue.QueueAttr, String> qitem : sr.qitems) {
                ids[i++] = qitem.get((Object)RemoteMailQueue.QueueAttr.id);
            }
        } else {
            throw ServiceException.INVALID_REQUEST("bad by: " + by, null);
        }
        rmq.action(server, action, ids);
        Element response = zsc.createElement(AdminConstants.MAIL_QUEUE_ACTION_RESPONSE);
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_manageMailQueue);
    }
}

