/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.wiki.WikiServiceException;
import com.zimbra.cs.wiki.WikiUtil;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitNotebook
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = InitNotebook.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        HashMap<String, String> reqAttrs = new HashMap<String, String>();
        for (Element el : request.listElements()) {
            reqAttrs.put(el.getName(), el.getText());
        }
        String username = (String)reqAttrs.get("name");
        String password = (String)reqAttrs.get("password");
        Element t = request.getOptionalElement("template");
        String template = null;
        String dest = null;
        if (t != null) {
            template = t.getText();
            dest = t.getAttribute("dest", "Template");
        }
        Element response = zsc.createElement(AdminConstants.INIT_NOTEBOOK_RESPONSE);
        ZimbraLog.security.info(ZimbraLog.encodeAttrs(new String[]{"cmd", "InitNotebook"}, reqAttrs));
        WikiUtil wiki = null;
        Element d = request.getOptionalElement("domain");
        if (d != null || this.isDomainAdminOnly(zsc)) {
            String key = d == null ? Provisioning.DomainBy.name.name() : d.getAttribute("by");
            String value = d == null ? this.getAuthTokenAccountDomain(zsc).getName() : d.getText();
            Domain domain = prov.get(Provisioning.DomainBy.fromString(key), value);
            if (domain == null) {
                throw AccountServiceException.NO_SUCH_DOMAIN(value);
            }
            this.checkDomainRight(zsc, domain, this.needGetAttrsRightConfigureWikiAccount(username));
            this.createWikiAccount(zsc, username, password, domain);
            wiki = WikiUtil.getInstance();
            wiki.initDomainWiki(domain, username);
        } else {
            Config config = prov.getConfig();
            this.checkRight(zsc, context, config, this.needGetAttrsRightConfigureWikiAccount(username));
            this.createWikiAccount(zsc, username, password, config);
            wiki = WikiUtil.getInstance();
            wiki.initDefaultWiki(username);
        }
        if (template != null) {
            try {
                wiki.startImport(username, dest, new File(template));
            }
            catch (Exception e) {
                throw WikiServiceException.ERROR("error importing wiki templates", e);
            }
        }
        return response;
    }

    private void createWikiAccount(ZimbraSoapContext zsc, String username, String password, Entry entry) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        if (username == null) {
            username = entry.getAttr("zimbraNotebookAccount", null);
        }
        if (username != null && prov.get(Provisioning.AccountBy.name, username) == null) {
            Map<String, Object> attrs = this.needGetAttrsRightCreateWikiAccount();
            this.checkDomainRightByEmail(zsc, username, Rights.Admin.R_createAccount);
            this.checkSetAttrsOnCreate(zsc, TargetType.account, username, attrs);
            prov.createAccount(username, password, attrs);
        }
    }

    private Map<String, Object> needGetAttrsRightCreateWikiAccount() {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraHideInGal", "TRUE");
        attrs.put("zimbraIsSystemResource", "TRUE");
        return attrs;
    }

    private Map<String, Object> needGetAttrsRightConfigureWikiAccount(String wikiAcctName) {
        HashMap<String, Object> attrsNeeds = new HashMap<String, Object>();
        attrsNeeds.put("zimbraNotebookAccount", wikiAcctName);
        return attrsNeeds;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_createAccount);
        notes.add("Needs rigths to set zimbraNotebookAccounton domain/global config.  If needs to create the wiki account, need the " + Rights.Admin.R_createAccount.getName() + " for the domain in" + "which the wiki account is to be created; and needs rights to set " + "zimbraHideInGal" + " and " + "zimbraIsSystemResource" + " on account.");
    }
}

