/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.RightCommand;
import com.zimbra.cs.account.accesscontrol.RightModifier;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.service.admin.RightDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrantRight
extends RightDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GrantRight.getZimbraSoapContext(context);
        Element eTarget = request.getElement("target");
        String targetType = eTarget.getAttribute("type");
        Provisioning.TargetBy targetBy = null;
        String target = null;
        if (TargetType.fromCode(targetType).needsTargetIdentity()) {
            targetBy = Provisioning.TargetBy.fromString(eTarget.getAttribute("by"));
            target = eTarget.getText();
        }
        Element eGrantee = request.getElement("grantee");
        String granteeType = eGrantee.getAttribute("type");
        Provisioning.GranteeBy granteeBy = Provisioning.GranteeBy.fromString(eGrantee.getAttribute("by"));
        String grantee = eGrantee.getText();
        Element eRight = request.getElement("right");
        String right = eRight.getText();
        RightModifier rightModifier = GrantRight.getRightModifier(eRight);
        RightCommand.grantRight(Provisioning.getInstance(), GrantRight.getAuthenticatedAccount(zsc), targetType, targetBy, target, granteeType, granteeBy, grantee, right, rightModifier);
        Element response = zsc.createElement(AdminConstants.GRANT_RIGHT_RESPONSE);
        return response;
    }

    static RightModifier getRightModifier(Element eRight) throws ServiceException {
        boolean deny = eRight.getAttributeBool("deny", false);
        boolean canDelegate = eRight.getAttributeBool("canDelegate", false);
        if (deny && canDelegate) {
            throw ServiceException.INVALID_REQUEST("cannot have both deny and canDelegate right modifiers", null);
        }
        RightModifier rightModifier = null;
        if (deny) {
            rightModifier = RightModifier.RM_DENY;
        } else if (canDelegate) {
            rightModifier = RightModifier.RM_CAN_DELEGATE;
        }
        return rightModifier;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Grantor must have the same or more rights on the same target or on a larger target set.");
    }
}

