/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.zimlet.ZimletUtil;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetZimletStatus
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetZimletStatus.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Element response = zsc.createElement(AdminConstants.GET_ZIMLET_STATUS_RESPONSE);
        Element elem = response.addElement("zimlets");
        List<Zimlet> zimlets = prov.listAllZimlets();
        zimlets = ZimletUtil.orderZimletsByPriority(zimlets);
        int priority = 0;
        for (Zimlet z : zimlets) {
            if (!this.hasRightsToList(zsc, z, Rights.Admin.R_listZimlet, null)) continue;
            this.doZimlet(zsc, context, z, elem, priority++);
        }
        for (Cos c : prov.getAllCos()) {
            if (!this.hasRightsToListCos(zsc, c, Rights.Admin.R_listCos, this.needGetAttrsRight())) continue;
            elem = response.addElement("cos");
            elem.addAttribute("name", c.getName());
            String[] z = ZimletUtil.getZimlets(c);
            for (int i = 0; i < z.length; ++i) {
                this.doZimlet(zsc, context, prov.getZimlet(z[i]), elem, -1);
            }
        }
        return response;
    }

    private void doZimlet(ZimbraSoapContext zsc, Map<String, Object> context, Zimlet z, Element elem, int priority) throws ServiceException {
        if (z == null) {
            return;
        }
        try {
            this.checkRight(zsc, context, z, Rights.Admin.R_getZimlet);
        }
        catch (ServiceException e) {
            if ("service.PERM_DENIED".equals(e.getCode())) {
                return;
            }
            throw e;
        }
        Element zim = elem.addElement("zimlet");
        zim.addAttribute("name", z.getName());
        zim.addAttribute("status", z.isEnabled() ? "enabled" : "disabled");
        zim.addAttribute("extension", z.isExtension() ? "true" : "false");
        if (priority >= 0) {
            zim.addAttribute("priority", priority);
        }
    }

    private Set<String> needGetAttrsRight() {
        HashSet<String> attrsNeeded = new HashSet<String>();
        attrsNeeded.add("zimbraZimletAvailableZimlets");
        return attrsNeeded;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_listZimlet);
        relatedRights.add(Rights.Admin.R_listCos);
        relatedRights.add(Rights.Admin.R_getZimlet);
    }
}

