/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetZimlet
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetZimlet.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Set<String> reqAttrs = this.getReqAttrs(request, AttributeClass.zimletEntry);
        Element z = request.getElement("zimlet");
        String n = z.getAttribute("name");
        Zimlet zimlet = prov.getZimlet(n);
        if (zimlet == null) {
            throw AccountServiceException.NO_SUCH_ZIMLET(n);
        }
        AdminAccessControl aac = this.checkRight(zsc, context, zimlet, AdminRight.PR_ALWAYS_ALLOW);
        Element response = zsc.createElement(AdminConstants.GET_ZIMLET_RESPONSE);
        GetZimlet.encodeZimlet(response, zimlet, reqAttrs, aac.getAttrRightChecker(zimlet));
        return response;
    }

    static void encodeZimlet(Element response, Zimlet zimlet) throws ServiceException {
        GetZimlet.encodeZimlet(response, zimlet, null, null);
    }

    static void encodeZimlet(Element response, Zimlet zimlet, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) throws ServiceException {
        Element zim = response.addElement("zimlet");
        zim.addAttribute("name", zimlet.getName());
        zim.addAttribute("id", zimlet.getId());
        String keyword = zimlet.getAttr("zimbraZimletKeyword");
        if (keyword != null) {
            zim.addAttribute("hasKeyword", keyword);
        }
        Map<String, Object> attrs = zimlet.getUnicodeAttrs();
        ToXML.encodeAttrs(zim, attrs, reqAttrs, attrRightChecker);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getZimlet);
        notes.add(String.format("Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.To allow an admin to get all attributes, grant the %s right", Rights.Admin.R_getZimlet.getName()));
    }
}

