/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.XMPPComponent;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetXMPPComponent
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetXMPPComponent.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Set<String> reqAttrs = this.getReqAttrs(request, AttributeClass.xmppComponent);
        Element id = request.getElement("xmppcomponent");
        String byStr = id.getAttribute("by");
        String name = id.getText();
        if (name == null || name.equals("")) {
            throw ServiceException.INVALID_REQUEST("must specify a value for a xmppcomponent", null);
        }
        Provisioning.XMPPComponentBy by = Provisioning.XMPPComponentBy.valueOf(byStr);
        XMPPComponent comp = prov.get(by, name);
        if (comp == null) {
            throw AccountServiceException.NO_SUCH_XMPP_COMPONENT(name);
        }
        AdminAccessControl aac = this.checkRight(zsc, context, comp, AdminRight.PR_ALWAYS_ALLOW);
        Element response = zsc.createElement(AdminConstants.GET_XMPPCOMPONENT_RESPONSE);
        GetXMPPComponent.encodeXMPPComponent(response, comp, reqAttrs, aac.getAttrRightChecker(comp));
        return response;
    }

    public static Element encodeXMPPComponent(Element parent, XMPPComponent comp) {
        return GetXMPPComponent.encodeXMPPComponent(parent, comp, null, null);
    }

    public static Element encodeXMPPComponent(Element parent, XMPPComponent comp, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) {
        Element e = parent.addElement("xmppcomponent");
        e.addAttribute("name", comp.getName());
        e.addAttribute("id", comp.getId());
        try {
            e.addAttribute("x-domainName", comp.getDomain().getName());
        }
        catch (ServiceException ex) {
            // empty catch block
        }
        try {
            e.addAttribute("x-serverName", comp.getServer().getName());
        }
        catch (ServiceException ex) {
            // empty catch block
        }
        ToXML.encodeAttrs(e, comp.getUnicodeAttrs(), reqAttrs, attrRightChecker);
        return e;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getXMPPComponent);
        notes.add(String.format("Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.To allow an admin to get all attributes, grant the %s right", Rights.Admin.R_getXMPPComponent.getName()));
    }
}

