/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.store.file.Volume;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetVolume
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext lc = GetVolume.getZimbraSoapContext(context);
        Server localServer = Provisioning.getInstance().getLocalServer();
        this.checkRight(lc, context, localServer, Rights.Admin.R_manageVolume);
        long idLong = request.getAttributeLong("id");
        Volume.validateID(idLong);
        short id = (short)idLong;
        Volume vol = Volume.getById(id);
        Element response = lc.createElement(AdminConstants.GET_VOLUME_RESPONSE);
        GetVolume.addVolumeElement(response, vol);
        return response;
    }

    static void addVolumeElement(Element parent, Volume vol) {
        Element eVol = parent.addElement("volume");
        eVol.addAttribute("id", vol.getId());
        eVol.addAttribute("type", vol.getType());
        eVol.addAttribute("name", vol.getName());
        eVol.addAttribute("rootpath", vol.getRootPath());
        eVol.addAttribute("mgbits", vol.getMboxGroupBits());
        eVol.addAttribute("mbits", vol.getMboxBits());
        eVol.addAttribute("fgbits", vol.getFileGroupBits());
        eVol.addAttribute("fbits", vol.getFileBits());
        eVol.addAttribute("compressBlobs", vol.getCompressBlobs());
        eVol.addAttribute("compressionThreshold", vol.getCompressionThreshold());
        eVol.addAttribute("isCurrent", GetVolume.getCurrentVolumeIds().contains(vol.getId()));
    }

    private static Set<Short> getCurrentVolumeIds() {
        HashSet<Short> current = new HashSet<Short>();
        Volume vol = Volume.getCurrentMessageVolume();
        if (vol != null) {
            current.add(vol.getId());
        }
        if ((vol = Volume.getCurrentSecondaryMessageVolume()) != null) {
            current.add(vol.getId());
        }
        if ((vol = Volume.getCurrentIndexVolume()) != null) {
            current.add(vol.getId());
        }
        return current;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_manageVolume);
    }
}

