/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetVersionInfo
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) {
        ZimbraSoapContext lc = GetVersionInfo.getZimbraSoapContext(context);
        Element response = lc.createElement(AdminConstants.GET_VERSION_INFO_RESPONSE);
        Element infoEl = response.addElement("info");
        String fullVersionInfo = BuildInfo.VERSION;
        if (!StringUtil.isNullOrEmpty(BuildInfo.TYPE)) {
            fullVersionInfo = fullVersionInfo + "." + BuildInfo.TYPE;
            infoEl.addAttribute("type", BuildInfo.TYPE);
        }
        infoEl.addAttribute("version", fullVersionInfo);
        infoEl.addAttribute("release", BuildInfo.RELEASE);
        infoEl.addAttribute("buildDate", BuildInfo.DATE);
        infoEl.addAttribute("host", BuildInfo.HOST);
        infoEl.addAttribute("majorversion", BuildInfo.MAJORVERSION);
        infoEl.addAttribute("minorversion", BuildInfo.MINORVERSION);
        infoEl.addAttribute("microversion", BuildInfo.MICROVERSION);
        infoEl.addAttribute("platform", BuildInfo.PLATFORM);
        return response;
    }

    @Override
    public boolean needsAdminAuth(Map<String, Object> context) {
        return false;
    }

    @Override
    public boolean needsAuth(Map<String, Object> context) {
        return false;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Do not need any right, all admins are allowed.");
    }
}

