/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ShareInfo;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.account.GetShareInfo;
import com.zimbra.cs.service.admin.ShareInfoHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetShareInfo
extends ShareInfoHandler {
    private static final String[] TARGET_ACCOUNT_PATH = new String[]{"owner"};

    @Override
    protected String[] getProxiedAccountElementPath() {
        return TARGET_ACCOUNT_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String key;
        ZimbraSoapContext zsc = GetShareInfo.getZimbraSoapContext(context);
        OperationContext octxt = GetShareInfo.getOperationContext(zsc, context);
        Provisioning prov = Provisioning.getInstance();
        Element eGrantee = request.getOptionalElement("grantee");
        byte granteeType = com.zimbra.cs.service.account.GetShareInfo.getGranteeType(eGrantee);
        String granteeId = eGrantee == null ? null : eGrantee.getAttribute("id", null);
        String granteeName = eGrantee == null ? null : eGrantee.getAttribute("name", null);
        Element eOwner = request.getElement("owner");
        Account ownerAcct = null;
        Provisioning.AccountBy acctBy = Provisioning.AccountBy.fromString(eOwner.getAttribute("by"));
        ownerAcct = prov.get(acctBy, key = eOwner.getText());
        if (ownerAcct == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(key);
        }
        this.checkAccountRight(zsc, ownerAcct, Rights.Admin.R_adminLoginAs);
        Element response = zsc.createElement(AdminConstants.GET_SHARE_INFO_RESPONSE);
        GetShareInfo.ResultFilterByTarget resultFilter = new GetShareInfo.ResultFilterByTarget(granteeId, granteeName);
        GetShareInfo.ShareInfoVisitor visitor = new GetShareInfo.ShareInfoVisitor(prov, response, null, resultFilter);
        ShareInfo.Discover.discover(octxt, prov, null, granteeType, ownerAcct, visitor);
        visitor.finish();
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_adminLoginAs);
        notes.add("Needs the " + Rights.Admin.R_adminLoginAs.getName() + " right on the owner account.");
    }
}

