/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.session.AdminSession;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.session.SessionCache;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetSessions
extends AdminDocumentHandler {
    private static final String SESSION_KEY = "GetSessionsCachedResult";

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        int i;
        Session.Type type;
        ZimbraSoapContext zsc = GetSessions.getZimbraSoapContext(context);
        Server localServer = Provisioning.getInstance().getLocalServer();
        this.checkRight(zsc, context, localServer, Rights.Admin.R_getSessions);
        Element response = zsc.createElement(AdminConstants.GET_SESSIONS_RESPONSE);
        String typeStr = request.getAttribute("type");
        try {
            type = Session.Type.valueOf(typeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw ServiceException.INVALID_REQUEST("invalid session type: " + typeStr, e);
        }
        SortBy sortBy = SortBy.fromString(request.getAttribute("sortBy", SortBy.nameAsc.name()));
        long offset = request.getAttributeLong("offset", 0L);
        long limit = request.getAttributeLong("limit", Integer.MAX_VALUE);
        boolean refresh = request.getAttributeBool("refresh", false);
        AdminSession adminSession = (AdminSession)this.getSession(zsc, Session.Type.ADMIN);
        CachedResult result = this.getResult(adminSession, type, refresh, sortBy);
        List<SessionInfo> sessions = result.sessions;
        int limitMax = (int)(offset + limit);
        for (i = (int)offset; i < limitMax && i < sessions.size(); ++i) {
            sessions.get(i).encodeSession(response);
        }
        response.addAttribute("more", i < sessions.size());
        response.addAttribute("total", sessions.size());
        return response;
    }

    public CachedResult getResult(AdminSession adminSession, Session.Type type, boolean refresh, final SortBy sortBy) {
        CachedResult result;
        List<Session> sessions = SessionCache.getActiveSessions(type);
        CachedResult cachedResult = result = adminSession == null || refresh ? null : (CachedResult)adminSession.getData(SESSION_KEY);
        if (result != null && result.type == type && result.sortBy == sortBy) {
            return result;
        }
        Provisioning prov = Provisioning.getInstance();
        result = new CachedResult();
        result.type = type;
        result.sortBy = sortBy;
        result.sessions = new ArrayList<SessionInfo>(sessions.size());
        for (Session s : sessions) {
            result.sessions.add(new SessionInfo(s, GetSessions.getName(prov, s.getAuthenticatedAccountId())));
        }
        Comparator<SessionInfo> comparator = new Comparator<SessionInfo>(){

            @Override
            public int compare(SessionInfo a, SessionInfo b) {
                switch (sortBy) {
                    case nameAsc: {
                        return a.getAccountName().compareToIgnoreCase(b.getAccountName());
                    }
                    case nameDesc: {
                        return -a.getAccountName().compareToIgnoreCase(b.getAccountName());
                    }
                    case accessedAsc: {
                        long diff = a.getAccessed() - b.getAccessed();
                        return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
                    }
                    case accessedDesc: {
                        long diff = a.getAccessed() - b.getAccessed();
                        return diff == 0L ? 0 : (diff > 0L ? -1 : 1);
                    }
                    case createdAsc: {
                        long diff = a.getAccessed() - b.getAccessed();
                        return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
                    }
                    case createdDesc: {
                        long diff = a.getAccessed() - b.getAccessed();
                        return diff == 0L ? 0 : (diff > 0L ? -1 : 1);
                    }
                }
                return 0;
            }
        };
        Collections.sort(result.sessions, comparator);
        if (adminSession != null) {
            adminSession.setData(SESSION_KEY, result);
        }
        return result;
    }

    private static String getName(Provisioning prov, String id) {
        try {
            Account acct = prov.get(Provisioning.AccountBy.id, id);
            return acct == null ? id : acct.getName();
        }
        catch (ServiceException e) {
            return id;
        }
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getSessions);
    }

    static class CachedResult {
        List<SessionInfo> sessions;
        Session.Type type;
        SortBy sortBy;

        CachedResult() {
        }
    }

    static class SessionInfo {
        private String mAccountName;
        private String mAccountId;
        private String mSessionId;
        private long mCreated;
        private long mAccessed;

        SessionInfo(Session s, String name) {
            this.mAccountName = name;
            this.mAccountId = s.getAuthenticatedAccountId();
            this.mSessionId = s.getSessionId();
            this.mCreated = s.getCreationTime();
            this.mAccessed = s.getLastAccessTime();
        }

        public String getAccountName() {
            return this.mAccountName;
        }

        public String getAccountId() {
            return this.mAccountId;
        }

        public String getSessionId() {
            return this.mSessionId;
        }

        public long getCreated() {
            return this.mCreated;
        }

        public long getAccessed() {
            return this.mAccessed;
        }

        void encodeSession(Element parent) {
            Element sElt = parent.addElement("s");
            sElt.addAttribute("zid", this.mAccountId);
            sElt.addAttribute("name", this.mAccountName);
            sElt.addAttribute("sid", this.mSessionId);
            sElt.addAttribute("cd", this.mCreated);
            sElt.addAttribute("ld", this.mAccessed);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SortBy {
        nameAsc,
        nameDesc,
        createdAsc,
        createdDesc,
        accessedAsc,
        accessedDesc;


        public static SortBy fromString(String s) throws ServiceException {
            try {
                return SortBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("invalid sortBy: " + s + ", valid values: " + Arrays.asList(SortBy.values()), e);
            }
        }
    }
}

