/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.util.CsvReader;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetServiceStatus
extends AdminDocumentHandler {
    private static final String ZMRRDFETCH = LC.zimbra_home.value() + "/libexec/zmrrdfetch";
    private static final String ZMSTATUSLOG_CSV = "zmstatuslog";

    @Override
    public Element handle(Element request, Map<String, Object> context) throws SoapFaultException, ServiceException {
        ZimbraSoapContext zsc = GetServiceStatus.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        String monitorHost = prov.getConfig().getAttr("zimbraLogHostname");
        if (monitorHost == null || monitorHost.trim().equals("")) {
            throw ServiceException.FAILURE("zimbraLogHostname is not configured", null);
        }
        Server monitorServer = prov.get(Provisioning.ServerBy.name, monitorHost);
        if (monitorServer == null) {
            throw ServiceException.FAILURE("could not find zimbraLogHostname server: " + monitorServer, null);
        }
        if (!prov.getLocalServer().getId().equalsIgnoreCase(monitorServer.getId())) {
            return this.proxyRequest(request, context, monitorServer);
        }
        Element response = zsc.createElement(AdminConstants.GET_SERVICE_STATUS_RESPONSE);
        TimeZone tz = TimeZone.getDefault();
        Element eTimeZone = response.addElement("timezone");
        eTimeZone.addAttribute("id", tz.getID());
        eTimeZone.addAttribute("displayName", tz.getDisplayName());
        boolean loggerEnabled = false;
        Server local = prov.getLocalServer();
        String[] services = local.getMultiAttr("zimbraServiceEnabled");
        if (services != null) {
            for (int i = 0; i < services.length && !loggerEnabled; ++i) {
                loggerEnabled = "logger".equals(services[i]);
            }
        }
        if (loggerEnabled) {
            HashSet<ServiceStatus> serviceStatus = new HashSet<ServiceStatus>();
            List<Server> servers = prov.getAllServers();
            for (Server s : servers) {
                String[] srvs;
                for (String service : srvs = s.getMultiAttr("zimbraServiceEnabled")) {
                    ServiceStatus st = new ServiceStatus();
                    st.server = s.getName();
                    st.service = service;
                    st.time = Long.toString(System.currentTimeMillis() / 1000L);
                    st.status = "0";
                    serviceStatus.add(st);
                }
            }
            BufferedReader in = null;
            try {
                String line;
                ProcessBuilder pb = new ProcessBuilder(ZMRRDFETCH, "-f", ZMSTATUSLOG_CSV);
                Process p = pb.start();
                in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                HashMap<String, CsvReader> hostStatus = new HashMap<String, CsvReader>();
                StringWriter currentWriter = null;
                String currentHost = null;
                while ((line = in.readLine()) != null) {
                    if ("".equals(line.trim())) continue;
                    if (line.startsWith("Host: ")) {
                        if (currentHost != null) {
                            hostStatus.put(currentHost, new CsvReader(new StringReader(currentWriter.toString())));
                        }
                        currentHost = line.substring("Host: ".length());
                        currentWriter = new StringWriter();
                        continue;
                    }
                    if (currentWriter == null) continue;
                    currentWriter.write(line + "\n");
                }
                if (currentHost != null && currentWriter != null) {
                    hostStatus.put(currentHost, new CsvReader(new StringReader(currentWriter.toString())));
                }
                List<ServiceStatus> status = ServiceStatus.parseData(hostStatus);
                for (ServiceStatus stat : status) {
                    serviceStatus.remove(stat);
                    serviceStatus.add(stat);
                }
                for (ServiceStatus stat : serviceStatus) {
                    if (!this.checkRights(zsc, stat.server)) {
                        ZimbraLog.misc.info("skipping server " + stat.server + ", has not right to get service status");
                        continue;
                    }
                    Element s = response.addElement("status");
                    s.addAttribute("server", stat.server);
                    s.addAttribute("service", stat.service);
                    s.addAttribute("t", stat.time);
                    s.setText(stat.status);
                }
            }
            catch (IOException e) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException x) {
                    // empty catch block
                }
                ServiceException.FAILURE("Unable to read logger stats", e);
            }
        }
        return response;
    }

    private boolean checkRights(ZimbraSoapContext zsc, String serverName) throws ServiceException {
        try {
            Server server = Provisioning.getInstance().get(Provisioning.ServerBy.name, serverName);
            GetServiceStatus.checkRight(zsc, server, Rights.Admin.R_getServiceStatus);
        }
        catch (ServiceException e) {
            if ("service.PERM_DENIED".equals(e.getCode())) {
                return false;
            }
            throw e;
        }
        return true;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getServiceStatus);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceStatus {
        String server;
        String service;
        String time;
        String status;

        private ServiceStatus() {
        }

        public int hashCode() {
            return this.server.hashCode();
        }

        public boolean equals(Object other) {
            boolean eq = false;
            if (other instanceof ServiceStatus) {
                ServiceStatus o = (ServiceStatus)other;
                eq = this.server.equals(o.server) && this.service.equals(o.service);
            }
            return eq;
        }

        static List<ServiceStatus> parseData(Map<String, CsvReader> data) throws IOException {
            ArrayList<ServiceStatus> results = new ArrayList<ServiceStatus>();
            for (String host : data.keySet()) {
                CsvReader r = data.get(host);
                ArrayList<String> columns = new ArrayList<String>(Arrays.asList(r.getColNames()));
                columns.remove("timestamp");
                HashMap<String, String> row = new HashMap<String, String>();
                String lastTS = null;
                while (r.hasNext()) {
                    String value;
                    String ts = r.getValue("timestamp");
                    boolean rowHasData = false;
                    for (String column : columns) {
                        value = r.getValue(column);
                        rowHasData = rowHasData || value != null;
                    }
                    if (!rowHasData) continue;
                    lastTS = ts;
                    row.clear();
                    for (String column : columns) {
                        value = r.getValue(column);
                        if (value == null) continue;
                        row.put(column, value);
                    }
                }
                if (lastTS == null) continue;
                for (String service : row.keySet()) {
                    String status = (String)row.get(service);
                    if (status == null || "".equals(status = status.trim())) continue;
                    ServiceStatus s = new ServiceStatus();
                    s.server = host;
                    s.time = lastTS;
                    s.service = service;
                    s.status = (double)Float.parseFloat(status) > 0.8 ? "1" : "0";
                    results.add(s);
                }
            }
            return results;
        }
    }
}

