/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetServerStats
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetServerStats.getZimbraSoapContext(context);
        List<Element> eStats = request.listElements("stat");
        HashSet<String> requestedNames = new HashSet<String>();
        for (int i = 0; i < eStats.size(); ++i) {
            requestedNames.add(eStats.get(i).getAttribute("name"));
        }
        Map<String, Object> allStats = ZimbraPerf.getStats();
        TreeMap<String, Object> returnedStats = new TreeMap<String, Object>();
        boolean returnAllStats = requestedNames.size() == 0;
        for (String name : allStats.keySet()) {
            if (!returnAllStats && !requestedNames.contains(name)) continue;
            returnedStats.put(name, allStats.get(name));
            requestedNames.remove(name);
        }
        if (requestedNames.size() != 0) {
            StringBuilder buf = new StringBuilder("Invalid stat name");
            if (requestedNames.size() > 1) {
                buf.append("s");
            }
            buf.append(": ").append(StringUtil.join(", ", requestedNames));
            throw ServiceException.FAILURE(buf.toString(), null);
        }
        Element response = zsc.createElement(AdminConstants.GET_SERVER_STATS_RESPONSE);
        for (String name : returnedStats.keySet()) {
            String stringVal = GetServerStats.toString(returnedStats.get(name));
            response.addElement("stat").addAttribute("name", name).setText(stringVal);
        }
        return response;
    }

    private static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double || value instanceof Float) {
            return String.format("%.2f", value);
        }
        return value.toString();
    }
}

