/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.rmgmt.RemoteManager;
import com.zimbra.cs.rmgmt.RemoteResult;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetServerNIFs
extends AdminDocumentHandler {
    private static final Pattern ADDR_PATTERN = Pattern.compile("(addr):([0-9\\.]+)", 2);
    private static final Pattern MASK_PATTERN = Pattern.compile("(mask):([0-9\\.xabcdef]+)", 2);
    private static final int KEY_GROUP = 1;
    private static final int VALUE_GROUP = 2;

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext lc = GetServerNIFs.getZimbraSoapContext(context);
        Element serverEl = request.getElement("server");
        String method = serverEl.getAttribute("by");
        String serverName = serverEl.getText();
        Provisioning prov = Provisioning.getInstance();
        Server server = prov.get(Provisioning.ServerBy.fromString(method), serverName);
        if (server == null) {
            throw ServiceException.INVALID_REQUEST("Cannot find server record for the host: " + serverName, null);
        }
        RemoteManager rmgr = RemoteManager.getRemoteManager(server);
        RemoteResult rr = rmgr.execute("zmserverips");
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(rr.getMStdout())));
        Element response = lc.createElement(AdminConstants.GET_SERVER_NIFS_RESPONSE);
        try {
            String line;
            while ((line = in.readLine()) != null) {
                Matcher IPmatcher = ADDR_PATTERN.matcher(line);
                Matcher maskMatcher = MASK_PATTERN.matcher(line);
                if (!IPmatcher.find() || !maskMatcher.find()) continue;
                Element elNIF = response.addElement("ni");
                elNIF.addElement("a").addAttribute("n", IPmatcher.group(1).toLowerCase()).setText(IPmatcher.group(2));
                elNIF.addElement("a").addAttribute("n", maskMatcher.group(1).toLowerCase()).setText(maskMatcher.group(2));
            }
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("exception occurred handling CLI command", e);
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Do not need any right, all admins are allowed.");
    }
}

