/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetServer
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetServer.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        boolean applyConfig = request.getAttributeBool("applyConfig", true);
        Set<String> reqAttrs = this.getReqAttrs(request, AttributeClass.server);
        Element d = request.getElement("server");
        String method = d.getAttribute("by");
        String name = d.getText();
        if (name == null || name.equals("")) {
            throw ServiceException.INVALID_REQUEST("must specify a value for a server", null);
        }
        Server server = prov.get(Provisioning.ServerBy.fromString(method), name);
        if (server == null) {
            throw AccountServiceException.NO_SUCH_SERVER(name);
        }
        AdminAccessControl aac = this.checkRight(zsc, context, server, AdminRight.PR_ALWAYS_ALLOW);
        prov.reload(server);
        Element response = zsc.createElement(AdminConstants.GET_SERVER_RESPONSE);
        GetServer.encodeServer(response, server, applyConfig, reqAttrs, aac.getAttrRightChecker(server));
        return response;
    }

    public static void encodeServer(Element e, Server s) throws ServiceException {
        GetServer.encodeServer(e, s, true, null, null);
    }

    public static void encodeServer(Element e, Server s, boolean applyConfig, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) throws ServiceException {
        Element server = e.addElement("server");
        server.addAttribute("name", s.getName());
        server.addAttribute("id", s.getId());
        Map<String, Object> attrs = s.getUnicodeAttrs(applyConfig);
        ToXML.encodeAttrs(server, attrs, reqAttrs, attrRightChecker);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getServer);
        notes.add(String.format("Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.To allow an admin to get all attributes, grant the %s right", Rights.Admin.R_getServer.getName()));
    }
}

