/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.SetUtil;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.AttrRight;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.AdminRightCheckPoint;
import com.zimbra.soap.DocumentDispatcher;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.SoapEngine;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetRightsDoc
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext lc = GetRightsDoc.getZimbraSoapContext(context);
        HashSet<String> specificPackages = null;
        for (Element ePackage : request.listElements("package")) {
            if (specificPackages == null) {
                specificPackages = new HashSet<String>();
            }
            specificPackages.add(ePackage.getAttribute("name"));
        }
        Element response = lc.createElement(AdminConstants.GET_RIGHTS_DOC_RESPONSE);
        this.doGetRightsDoc(context, specificPackages, response);
        return response;
    }

    private void doGetRightsDoc(Map<String, Object> context, HashSet<String> specificPackages, Element response) throws ServiceException {
        SoapEngine engine = (SoapEngine)context.get("zimbra.engine");
        DocumentDispatcher dispatcher = engine.getDocumentDispatcher();
        Map<QName, DocumentHandler> handlers = dispatcher.getHandlers();
        TreeMap<String, TreeMap<String, AdminRightCheckPoint>> handlersWithRightsDoc = new TreeMap<String, TreeMap<String, AdminRightCheckPoint>>();
        for (Map.Entry<QName, DocumentHandler> handler : handlers.entrySet()) {
            DocumentHandler soapHandler = handler.getValue();
            if (!(soapHandler instanceof AdminRightCheckPoint)) continue;
            QName qname = handler.getKey();
            String pkg = soapHandler.getClass().getPackage().getName();
            if (specificPackages != null && !specificPackages.contains(pkg)) continue;
            TreeMap<String, AdminRightCheckPoint> handlersInPkg = (TreeMap<String, AdminRightCheckPoint>)handlersWithRightsDoc.get(pkg);
            if (handlersInPkg == null) {
                handlersInPkg = new TreeMap<String, AdminRightCheckPoint>();
                handlersWithRightsDoc.put(pkg, handlersInPkg);
            }
            handlersInPkg.put(qname.getQualifiedName(), (AdminRightCheckPoint)((Object)soapHandler));
        }
        HashSet<AdminRight> usedRights = new HashSet<AdminRight>();
        ArrayList<AdminRight> relatedRights = new ArrayList<AdminRight>();
        ArrayList<String> notes = new ArrayList<String>();
        for (Map.Entry entry : handlersWithRightsDoc.entrySet()) {
            String pkg = (String)entry.getKey();
            Map handlersInPkg = (Map)entry.getValue();
            Element ePackage = response.addElement("package");
            ePackage.addAttribute("name", pkg);
            for (Map.Entry handler : handlersInPkg.entrySet()) {
                String soapName = (String)handler.getKey();
                AdminRightCheckPoint soapHandler = (AdminRightCheckPoint)handler.getValue();
                relatedRights.clear();
                notes.clear();
                soapHandler.docRights(relatedRights, notes);
                Element eCommand = ePackage.addElement("cmd");
                eCommand.addAttribute("name", soapName);
                Element eRights = eCommand.addElement("rights");
                for (AdminRight adminRight : relatedRights) {
                    Element eRight = eRights.addElement("right");
                    eRight.addAttribute("name", adminRight.getName());
                    usedRights.add(adminRight);
                }
                Element eNotes = eCommand.addElement("desc");
                for (String note : notes) {
                    eNotes.addElement("note").setText(note);
                }
            }
        }
        this.genNotUsed(usedRights, response);
        this.genDomainAdminRights(context, response);
    }

    private void genNotUsed(Set<AdminRight> usedRights, Element response) throws ServiceException {
        HashSet<AdminRight> allRights = new HashSet<AdminRight>();
        allRights.addAll(RightManager.getInstance().getAllAdminRights().values());
        Set<AdminRight> notUsed = SetUtil.subtract(allRights, usedRights);
        for (AdminRight nu : notUsed) {
            response.addElement("notUsed").setText(nu.getName());
        }
    }

    private void genDomainAdminRights(Map<String, Object> context, Element response) throws ServiceException {
        Element eDomainAdmin = response.addElement("domainAdmin-copypaste-to-zimbra-rights-domainadmin-xml-template");
        SoapEngine engine = (SoapEngine)context.get("zimbra.engine");
        DocumentDispatcher dispatcher = engine.getDocumentDispatcher();
        Map<QName, DocumentHandler> handlers = dispatcher.getHandlers();
        TreeMap rights = new TreeMap();
        for (TargetType tt : TargetType.values()) {
            rights.put(tt, new TreeSet());
        }
        ((TreeSet)rights.get((Object)TargetType.account)).add(Rights.Admin.R_setDomainAdminAccountAndCalendarResourceAttrs.getName());
        ((TreeSet)rights.get((Object)TargetType.calresource)).add(Rights.Admin.R_setDomainAdminAccountAndCalendarResourceAttrs.getName());
        ((TreeSet)rights.get((Object)TargetType.calresource)).add(Rights.Admin.R_setDomainAdminCalendarResourceAttrs.getName());
        ((TreeSet)rights.get((Object)TargetType.dl)).add(Rights.Admin.R_setDomainAdminDistributionListAttrs.getName());
        ((TreeSet)rights.get((Object)TargetType.domain)).add(Rights.Admin.R_setDomainAdminDomainAttrs.getName());
        for (Map.Entry<QName, DocumentHandler> entry : handlers.entrySet()) {
            AdminDocumentHandler adminHandler;
            DocumentHandler soapHandler = entry.getValue();
            if (!(soapHandler instanceof AdminRightCheckPoint) || !(soapHandler instanceof AdminDocumentHandler) || !(adminHandler = (AdminDocumentHandler)soapHandler).domainAuthSufficient(context)) continue;
            ArrayList<AdminRight> relatedRights = new ArrayList<AdminRight>();
            ArrayList<String> notes = new ArrayList<String>();
            adminHandler.docRights(relatedRights, notes);
            for (AdminRight r : relatedRights) {
                if (r.isPresetRight()) {
                    TargetType tt = r.getTargetType();
                    ((TreeSet)rights.get((Object)tt)).add(r.getName());
                    continue;
                }
                if (!r.isAttrRight()) continue;
                Set<TargetType> tts = ((AttrRight)r).getTargetTypes();
                for (TargetType tt : tts) {
                    ((TreeSet)rights.get((Object)tt)).add(r.getName());
                }
            }
        }
        for (Map.Entry<QName, DocumentHandler> entry : rights.entrySet()) {
            TargetType tt = (TargetType)((Object)entry.getKey());
            if (((TreeSet)((Object)entry.getValue())).size() <= 0) continue;
            Element eRight = eDomainAdmin.addElement("right").addAttribute("name", "domainAdmin" + tt.getPrettyName() + "Rights").addAttribute("type", "combo");
            eRight.addElement("desc").setText("domain admin " + tt.getCode() + " right");
            Element eRights = eRight.addElement("rights");
            for (String r : (TreeSet)((Object)entry.getValue())) {
                eRights.addElement("r").addAttribute("n", r);
            }
        }
    }

    @Override
    public boolean needsAuth(Map<String, Object> context) {
        return false;
    }

    @Override
    public boolean needsAdminAuth(Map<String, Object> context) {
        return false;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Do not need any right, all admins are allowed.");
    }
}

