/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.session.AdminSession;
import com.zimbra.cs.session.Session;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetQuotaUsage
extends AdminDocumentHandler {
    public static final String BY_NAME = "name";
    public static final String BY_ID = "id";
    public static final String SORT_PERCENT_USED = "percentUsed";
    public static final String SORT_TOTAL_USED = "totalUsed";
    public static final String SORT_QUOTA_LIMIT = "quotaLimit";
    public static final String SORT_ACCOUNT = "account";
    private static final String QUOTA_USAGE_CACHE_KEY = "GetQuotaUsage";

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        int i;
        ArrayList<AccountQuota> quotas;
        ZimbraSoapContext zsc = GetQuotaUsage.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        int limit = (int)request.getAttributeLong("limit", Integer.MAX_VALUE);
        if (limit == 0) {
            limit = Integer.MAX_VALUE;
        }
        int offset = (int)request.getAttributeLong("offset", 0L);
        String domain = request.getAttribute("domain", null);
        String sortBy = request.getAttribute("sortBy", SORT_TOTAL_USED);
        boolean sortAscending = request.getAttributeBool("sortAscending", false);
        if (!(sortBy.equals(SORT_TOTAL_USED) || sortBy.equals(SORT_PERCENT_USED) || sortBy.equals(SORT_QUOTA_LIMIT) || sortBy.equals(SORT_ACCOUNT))) {
            throw ServiceException.INVALID_REQUEST("sortBy must be percentUsed or totalUsed", null);
        }
        if (this.isDomainAdminOnly(zsc)) {
            if (domain == null) {
                domain = this.getAuthTokenAccountDomain(zsc).getName();
            }
            if (domain == null) {
                throw AccountServiceException.INVALID_REQUEST("no domain", null);
            }
        }
        Domain d = null;
        if (domain != null && (d = prov.get(Provisioning.DomainBy.name, domain)) == null) {
            throw AccountServiceException.NO_SUCH_DOMAIN(domain);
        }
        if (d != null) {
            this.checkDomainRight(zsc, d, (Object)Rights.Admin.R_getDomainQuotaUsage);
        } else {
            GetQuotaUsage.checkRight(zsc, null, AdminRight.PR_SYSTEM_ADMIN_ONLY);
        }
        QuotaUsageParams params = new QuotaUsageParams(d, sortBy, sortAscending);
        AdminSession session = (AdminSession)this.getSession(zsc, Session.Type.ADMIN);
        if (session != null) {
            QuotaUsageParams cachedParams = GetQuotaUsage.getCachedQuotaUsage(session);
            if (cachedParams == null || !cachedParams.equals(params)) {
                quotas = params.doSearch();
                GetQuotaUsage.setCachedQuotaUsage(session, params);
            } else {
                quotas = cachedParams.doSearch();
            }
        } else {
            quotas = params.doSearch();
        }
        Element response = zsc.createElement(AdminConstants.GET_QUOTA_USAGE_RESPONSE);
        int limitMax = offset + limit;
        for (i = offset; i < limitMax && i < quotas.size(); ++i) {
            AccountQuota quota = quotas.get(i);
            Element account = response.addElement(SORT_ACCOUNT);
            account.addAttribute(BY_NAME, quota.name);
            account.addAttribute(BY_ID, quota.id);
            account.addAttribute("used", quota.quotaUsed);
            account.addAttribute("limit", quota.quotaLimit);
        }
        response.addAttribute("more", i < quotas.size());
        response.addAttribute("searchTotal", quotas.size());
        return response;
    }

    static synchronized QuotaUsageParams getCachedQuotaUsage(AdminSession session) {
        return (QuotaUsageParams)session.getData(QUOTA_USAGE_CACHE_KEY);
    }

    static synchronized void setCachedQuotaUsage(AdminSession session, QuotaUsageParams params) {
        session.setData(QUOTA_USAGE_CACHE_KEY, params);
    }

    static synchronized void clearCachedQuotaUsage(AdminSession session) {
        session.clearData(QUOTA_USAGE_CACHE_KEY);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getDomainQuotaUsage);
        notes.add("If a domain is specified, need the the domain right " + Rights.Admin.R_getDomainQuotaUsage.getName() + ".  If domain is not specified, only system admins are allowed.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class QuotaUsageParams {
        String mDomainId;
        String mSortBy;
        boolean mSortAscending;
        ArrayList<AccountQuota> mResult;

        QuotaUsageParams(Domain d, String sortBy, boolean sortAscending) {
            this.mDomainId = d == null ? "" : d.getId();
            this.mSortBy = sortBy == null ? "" : sortBy;
            this.mSortAscending = sortAscending;
        }

        public boolean equals(Object o) {
            if (!(o instanceof QuotaUsageParams)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            QuotaUsageParams other = (QuotaUsageParams)o;
            return this.mDomainId.equals(other.mDomainId) && this.mSortBy.equals(other.mSortBy) && this.mSortAscending == other.mSortAscending;
        }

        ArrayList<AccountQuota> doSearch() throws ServiceException {
            if (this.mResult != null) {
                return this.mResult;
            }
            ArrayList<AccountQuota> result = new ArrayList<AccountQuota>();
            String query = String.format("(zimbraMailHost=%s)", DocumentHandler.getLocalHost());
            Provisioning prov = Provisioning.getInstance();
            int flags = 513;
            Domain d = this.mDomainId.equals("") ? null : prov.get(Provisioning.DomainBy.id, this.mDomainId);
            List<NamedEntry> accounts = d != null ? prov.searchAccounts(d, query, null, null, true, flags) : prov.searchAccounts(query, null, null, true, flags);
            Map<String, Long> quotaUsed = MailboxManager.getInstance().getMailboxSizes(accounts);
            for (NamedEntry obj : accounts) {
                if (!(obj instanceof Account)) continue;
                Account acct = (Account)obj;
                AccountQuota aq = new AccountQuota();
                aq.id = acct.getId();
                aq.name = acct.getName();
                aq.quotaLimit = acct.getLongAttr("zimbraMailQuota", 0L);
                aq.sortQuotaLimit = aq.quotaLimit == 0L ? Long.MAX_VALUE : aq.quotaLimit;
                Long used = quotaUsed.get(acct.getId());
                aq.quotaUsed = used == null ? 0L : used;
                aq.percentQuotaUsed = aq.quotaLimit > 0L ? (float)aq.quotaUsed / (float)aq.quotaLimit : 0.0f;
                result.add(aq);
            }
            final boolean sortByTotal = this.mSortBy.equals(GetQuotaUsage.SORT_TOTAL_USED);
            final boolean sortByQuota = this.mSortBy.equals(GetQuotaUsage.SORT_QUOTA_LIMIT);
            final boolean sortByAccount = this.mSortBy.equals(GetQuotaUsage.SORT_ACCOUNT);
            Comparator<AccountQuota> comparator = new Comparator<AccountQuota>(){

                @Override
                public int compare(AccountQuota a, AccountQuota b) {
                    int comp = 0;
                    if (sortByTotal) {
                        if (a.quotaUsed > b.quotaUsed) {
                            comp = 1;
                        } else if (a.quotaUsed < b.quotaUsed) {
                            comp = -1;
                        }
                    } else if (sortByQuota) {
                        if (a.sortQuotaLimit > b.sortQuotaLimit) {
                            comp = 1;
                        } else if (a.sortQuotaLimit < b.sortQuotaLimit) {
                            comp = -1;
                        }
                    } else if (sortByAccount) {
                        comp = a.name.compareToIgnoreCase(b.name);
                    } else if (a.percentQuotaUsed > b.percentQuotaUsed) {
                        comp = 1;
                    } else if (a.percentQuotaUsed < b.percentQuotaUsed) {
                        comp = -1;
                    }
                    return QuotaUsageParams.this.mSortAscending ? comp : -comp;
                }
            };
            Collections.sort(result, comparator);
            this.mResult = result;
            return this.mResult;
        }
    }

    public static class AccountQuota {
        public String name;
        public String id;
        public long quotaLimit;
        public long sortQuotaLimit;
        public long quotaUsed;
        public float percentQuotaUsed;
    }
}

