/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ShareInfo;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.account.GetShareInfo;
import com.zimbra.cs.service.admin.ShareInfoHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetPublishedShareInfo
extends ShareInfoHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String key;
        Provisioning.AccountBy acctBy;
        ZimbraSoapContext zsc = GetPublishedShareInfo.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        NamedEntry taregtEntry = this.getPublishableTargetEntry(zsc, request, prov);
        this.checkDistributionListRight(zsc, (DistributionList)taregtEntry, Rights.Admin.R_getDistributionListShareInfo);
        Element response = zsc.createElement(AdminConstants.GET_PUBLISHED_SHARE_INFO_RESPONSE);
        Account owner = null;
        Element eOwner = request.getOptionalElement("owner");
        if (eOwner != null && (owner = prov.get(acctBy = Provisioning.AccountBy.fromString(eOwner.getAttribute("by")), key = eOwner.getText())) == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(key);
        }
        GetShareInfo.ShareInfoVisitor visitor = new GetShareInfo.ShareInfoVisitor(prov, response, null, null);
        ShareInfo.Published.getPublished(prov, (DistributionList)taregtEntry, true, owner, visitor);
        visitor.finish();
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getDistributionListShareInfo);
    }
}

