/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.session.AdminSession;
import com.zimbra.cs.session.Session;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMailboxStats
extends AdminDocumentHandler {
    private static final String GET_MAILBOX_STATS_CACHE_KEY = "GetMailboxStats";

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetMailboxStats.getZimbraSoapContext(context);
        Server localServer = Provisioning.getInstance().getLocalServer();
        this.checkRight(zsc, context, localServer, Rights.Admin.R_getMailboxStats);
        MailboxStats stats = null;
        AdminSession session = (AdminSession)this.getSession(zsc, Session.Type.ADMIN);
        if (session != null) {
            MailboxStats cachedStats = (MailboxStats)session.getData(GET_MAILBOX_STATS_CACHE_KEY);
            if (cachedStats == null) {
                stats = this.doStats();
                session.setData(GET_MAILBOX_STATS_CACHE_KEY, stats);
            } else {
                stats = cachedStats;
            }
        } else {
            stats = this.doStats();
        }
        Element response = zsc.createElement(AdminConstants.GET_MAILBOX_STATS_RESPONSE);
        Element statsElem = response.addElement("stats");
        statsElem.addAttribute("numMboxes", stats.mNumMboxes);
        statsElem.addAttribute("totalSize", stats.mTotalSize);
        return response;
    }

    private MailboxStats doStats() throws ServiceException {
        List<Mailbox.MailboxData> mailboxes = this.doSearch();
        MailboxStats stats = new MailboxStats();
        for (Mailbox.MailboxData m : mailboxes) {
            ++stats.mNumMboxes;
            stats.mTotalSize += m.size;
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Mailbox.MailboxData> doSearch() throws ServiceException {
        List<Mailbox.MailboxData> result = null;
        Object object = DbMailbox.getSynchronizer();
        synchronized (object) {
            DbPool.Connection conn = null;
            try {
                conn = DbPool.getConnection();
                result = DbMailbox.getMailboxRawData(conn);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.quietClose(conn);
        }
        return result;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getMailboxStats);
    }

    private static class MailboxStats {
        long mNumMboxes = 0L;
        long mTotalSize = 0L;

        private MailboxStats() {
        }
    }
}

