/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.rmgmt.RemoteManager;
import com.zimbra.cs.rmgmt.RemoteResult;
import com.zimbra.cs.rmgmt.RemoteResultParser;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMailQueueInfo
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Map<String, String> queueInfo;
        Element serverElem;
        String serverName;
        ZimbraSoapContext zsc = GetMailQueueInfo.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Server server = prov.get(Provisioning.ServerBy.name, serverName = (serverElem = request.getElement("server")).getAttribute("name"));
        if (server == null) {
            throw ServiceException.INVALID_REQUEST("server with name " + serverName + " could not be found", null);
        }
        this.checkRight(zsc, context, server, Rights.Admin.R_manageMailQueue);
        RemoteManager rmgr = RemoteManager.getRemoteManager(server);
        RemoteResult rr = rmgr.execute("zmqstat all");
        try {
            queueInfo = RemoteResultParser.parseSingleMap(rr);
        }
        catch (IOException ioe) {
            throw ServiceException.FAILURE("exception occurred handling command", ioe);
        }
        if (queueInfo == null) {
            throw ServiceException.FAILURE("server " + serverName + " returned no result", null);
        }
        Element response = zsc.createElement(AdminConstants.GET_MAIL_QUEUE_INFO_RESPONSE);
        serverElem = response.addElement("server");
        serverElem.addAttribute("name", serverName);
        for (String k : queueInfo.keySet()) {
            Element queue = serverElem.addElement("queue");
            queue.addAttribute("name", k);
            queue.addAttribute("n", queueInfo.get(k));
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_manageMailQueue);
    }
}

