/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.rmgmt.RemoteMailQueue;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMailQueue
extends AdminDocumentHandler {
    public static final int MAIL_QUEUE_QUERY_DEFAULT_LIMIT = 30;
    public static final int MAIL_QUEUE_SCAN_DEFUALT_WAIT_SECONDS = 3;
    public static final int MAIL_QUEUE_SUMMARY_CUTOFF = 100;

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Element serverElem;
        String serverName;
        ZimbraSoapContext zsc = GetMailQueue.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Server server = prov.get(Provisioning.ServerBy.name, serverName = (serverElem = request.getElement("server")).getAttribute("name"));
        if (server == null) {
            throw ServiceException.INVALID_REQUEST("server with name " + serverName + " could not be found", null);
        }
        this.checkRight(zsc, context, server, Rights.Admin.R_manageMailQueue);
        Element queueElem = serverElem.getElement("queue");
        String queueName = queueElem.getAttribute("name");
        boolean scan = queueElem.getAttributeBool("scan", false);
        long waitMillis = queueElem.getAttributeLong("wait", 3L) * 1000L;
        Element queryElem = queueElem.getElement("query");
        int offset = (int)queryElem.getAttributeLong("offset", 0L);
        int limit = (int)queryElem.getAttributeLong("limit", 30L);
        Query query = GetMailQueue.buildLuceneQuery(queryElem);
        RemoteMailQueue rmq = RemoteMailQueue.getRemoteMailQueue(server, queueName, scan);
        boolean stillScanning = rmq.waitForScan(waitMillis);
        RemoteMailQueue.SearchResult sr = rmq.search(query, offset, limit);
        Element response = zsc.createElement(AdminConstants.GET_MAIL_QUEUE_RESPONSE);
        serverElem = response.addElement("server");
        serverElem.addAttribute("name", serverName);
        queueElem = serverElem.addElement("queue");
        queueElem.addAttribute("name", queueName);
        queueElem.addAttribute("time", rmq.getScanTime());
        queueElem.addAttribute("scan", stillScanning);
        queueElem.addAttribute("total", rmq.getNumMessages());
        queueElem.addAttribute("more", offset + limit < sr.hits);
        block0: for (RemoteMailQueue.QueueAttr queueAttr : sr.sitems.keySet()) {
            List<RemoteMailQueue.SummaryItem> slist = sr.sitems.get((Object)queueAttr);
            Collections.sort(slist);
            Element qsElem = queueElem.addElement("qs");
            qsElem.addAttribute("type", queueAttr.toString());
            int i = 0;
            for (RemoteMailQueue.SummaryItem sitem : slist) {
                if (++i > 100) continue block0;
                Element qsiElem = qsElem.addElement("qsi");
                qsiElem.addAttribute("n", sitem.count());
                qsiElem.addAttribute("t", sitem.term());
            }
        }
        for (Map map : sr.qitems) {
            Element qiElem = queueElem.addElement("qi");
            for (RemoteMailQueue.QueueAttr attr : map.keySet()) {
                qiElem.addAttribute(attr.toString(), (String)map.get((Object)attr));
            }
        }
        return response;
    }

    public static Query buildLuceneQuery(Element queryElem) throws ServiceException {
        BooleanQuery fq = new BooleanQuery();
        boolean emptyQuery = true;
        Iterator<Element> fieldIter = queryElem.elementIterator("field");
        while (fieldIter.hasNext()) {
            emptyQuery = false;
            Element fieldElement = fieldIter.next();
            String fieldName = fieldElement.getAttribute("name");
            BooleanQuery mq = new BooleanQuery();
            Iterator<Element> matchIter = fieldElement.elementIterator("match");
            while (matchIter.hasNext()) {
                Element matchElement = matchIter.next();
                String matchValue = matchElement.getAttribute("value");
                Term term = new Term(fieldName, matchValue);
                mq.add(new TermQuery(term), BooleanClause.Occur.SHOULD);
            }
            fq.add(mq, BooleanClause.Occur.MUST);
        }
        if (emptyQuery) {
            return null;
        }
        return fq;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_manageMailQueue);
    }
}

