/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetLoggerStats
extends AdminDocumentHandler {
    private static final String ZMRRDFETCH = LC.zimbra_home.value() + "/libexec/zmrrdfetch";
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\\"?\\s*,\\s*\\\"?");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetLoggerStats.getZimbraSoapContext(context);
        this.checkRight(zsc, context, null, AdminRight.PR_SYSTEM_ADMIN_ONLY);
        Provisioning prov = Provisioning.getInstance();
        String monitorHost = prov.getConfig().getAttr("zimbraLogHostname");
        if (monitorHost == null || monitorHost.trim().equals("")) {
            throw ServiceException.FAILURE("zimbraLogHostname is not configured", null);
        }
        Server monitorServer = prov.get(Provisioning.ServerBy.name, monitorHost);
        if (monitorServer == null) {
            throw ServiceException.FAILURE("could not find zimbraLogHostname server: " + monitorServer, null);
        }
        if (!prov.getLocalServer().getId().equalsIgnoreCase(monitorServer.getId())) {
            return this.proxyRequest(request, context, monitorServer);
        }
        Element response = zsc.createElement(AdminConstants.GET_LOGGER_STATS_RESPONSE);
        boolean loggerEnabled = false;
        Server local = prov.getLocalServer();
        String[] services = local.getMultiAttr("zimbraServiceEnabled");
        if (services != null) {
            for (int i = 0; i < services.length && !loggerEnabled; ++i) {
                loggerEnabled = "logger".equals(services[i]);
            }
        }
        if (loggerEnabled) {
            Element host = request.getOptionalElement("hostname");
            Element stats = request.getOptionalElement("stats");
            Element start = request.getOptionalElement("startTime");
            Element end = request.getOptionalElement("endTime");
            Element values = null;
            HashSet<String> counters = null;
            if (stats != null && (values = stats.getOptionalElement("values")) != null) {
                List<Element> counterList = values.listElements("stat");
                if (counterList.size() > 0) {
                    counters = new HashSet<String>(counterList.size());
                }
                for (Element e : counterList) {
                    counters.add(e.getAttribute("name"));
                }
            }
            if (host == null && stats == null) {
                GetLoggerStats.fetchHostnames(response);
                return response;
            } else if (host != null && stats == null) {
                GetLoggerStats.fetchGroupNames(response, host.getAttribute("hn"));
                return response;
            } else if (stats != null && host == null) {
                String limitStr = stats.getAttribute("limit", null);
                boolean limit = limitStr != null && !"no".equalsIgnoreCase(limitStr) && !"false".equalsIgnoreCase(limitStr) && !"0".equalsIgnoreCase(limitStr);
                String startTime = null;
                String endTime = null;
                if (start != null || end != null) {
                    if (start == null || end == null) {
                        throw ServiceException.FAILURE("both start and end must be specified", null);
                    }
                    startTime = start.getAttribute("time");
                    endTime = end.getAttribute("time");
                    GetLoggerStats.fetchColumnData(response, counters, stats.getAttribute("name"), startTime, endTime, limit);
                    return response;
                } else {
                    GetLoggerStats.fetchColumnData(response, counters, stats.getAttribute("name"), limit);
                }
                return response;
            } else {
                if (stats == null || host == null) throw ServiceException.FAILURE("Unknown query combination", null);
                String statsText = stats.getText();
                if (statsText != null && statsText.trim().length() > 0) {
                    GetLoggerStats.fetchColumnNames(response, host.getAttribute("hn"), stats.getAttribute("name"));
                    return response;
                } else {
                    String limitStr = stats.getAttribute("limit", null);
                    boolean limit = limitStr != null && !"no".equalsIgnoreCase(limitStr) && !"false".equalsIgnoreCase(limitStr) && !"0".equalsIgnoreCase(limitStr);
                    String startTime = null;
                    String endTime = null;
                    if (start != null || end != null) {
                        if (start == null || end == null) {
                            throw ServiceException.FAILURE("both start and end must be specified", null);
                        }
                        startTime = start.getAttribute("time");
                        endTime = end.getAttribute("time");
                        GetLoggerStats.fetchColumnData(response, counters, host.getAttribute("hn"), stats.getAttribute("name"), startTime, endTime, limit);
                        return response;
                    } else {
                        GetLoggerStats.fetchColumnData(response, counters, host.getAttribute("hn"), stats.getAttribute("name"), limit);
                    }
                }
            }
            return response;
        } else {
            response.addElement("note").setText("Logger is not enabled");
        }
        return response;
    }

    static void fetchHostnames(Element response) throws ServiceException {
        Iterator<String> results = GetLoggerStats.execfetch("-n");
        while (results.hasNext()) {
            Element host = response.addElement("hostname");
            host.addAttribute("hn", results.next());
        }
    }

    static void fetchGroupNames(Element response, String hostname) throws ServiceException {
        Iterator<String> results = GetLoggerStats.execfetch("-l", "-h", hostname);
        Element host = response.addElement("hostname");
        host.addAttribute("hn", hostname);
        while (results.hasNext()) {
            Element stats = host.addElement("stats");
            stats.addAttribute("name", results.next());
        }
    }

    static void fetchColumnNames(Element response, String hostname, String group) throws ServiceException {
        Iterator<String> results = GetLoggerStats.execfetch("-l", "-h", hostname, "-f", group);
        Element host = response.addElement("hostname");
        host.addAttribute("hn", hostname);
        Element stats = host.addElement("stats");
        stats.addAttribute("name", group);
        Element values = stats.addElement("values");
        while (results.hasNext()) {
            String result;
            String name = result = results.next();
            int idx = result.indexOf(" :: ");
            Element stat = values.addElement("stat");
            if (idx != -1) {
                name = result.substring(0, idx);
                String unit = result.substring(idx + 4);
                stat.addAttribute("type", unit);
            }
            stat.addAttribute("name", name);
        }
    }

    static void fetchColumnData(Element response, Set<String> counters, String group, String start, String end, boolean limit) throws ServiceException {
        Iterator<String> results = limit ? GetLoggerStats.execfetch("-c", "-f", group, "-s", start, "-e", end) : GetLoggerStats.execfetch("-f", group, "-s", start, "-e", end);
        GetLoggerStats.populateResponseData(response, counters, group, results);
    }

    static void fetchColumnData(Element response, Set<String> counters, String hostname, String group, String start, String end, boolean limit) throws ServiceException {
        Iterator<String> results = limit ? GetLoggerStats.execfetch("-c", "-h", hostname, "-f", group, "-s", start, "-e", end) : GetLoggerStats.execfetch("-h", hostname, "-f", group, "-s", start, "-e", end);
        GetLoggerStats.populateResponseData(response, counters, hostname, group, results);
    }

    static void fetchColumnData(Element response, Set<String> counters, String group, boolean limit) throws ServiceException {
        Iterator<String> results = limit ? GetLoggerStats.execfetch("-c", "-f", group) : GetLoggerStats.execfetch("-f", group);
        GetLoggerStats.populateResponseData(response, counters, group, results);
    }

    static void fetchColumnData(Element response, Set<String> counters, String hostname, String group, boolean limit) throws ServiceException {
        Iterator<String> results = limit ? GetLoggerStats.execfetch("-c", "-h", hostname, "-f", group) : GetLoggerStats.execfetch("-h", hostname, "-f", group);
        GetLoggerStats.populateResponseData(response, counters, hostname, group, results);
    }

    static void populateResponseData(Element response, Set<String> counters, String hostname, String group, Iterator<String> results) throws ServiceException {
        if (!results.hasNext()) {
            return;
        }
        String line = results.next();
        String[] columns = SPLIT_PATTERN.split(line);
        Element host = response.addElement("hostname");
        host.addAttribute("hn", hostname);
        Element stats = host.addElement("stats");
        stats.addAttribute("name", group);
        while (results.hasNext()) {
            line = results.next();
            String[] data = SPLIT_PATTERN.split(line);
            boolean rowHasData = false;
            int j = data.length;
            for (int i = 1; i < j; ++i) {
                rowHasData = rowHasData || data[i] != null && !data[i].trim().equals("");
            }
            if (!rowHasData) continue;
            Element values = stats.addElement("values");
            values.addAttribute("t", data[0]);
            int j2 = data.length;
            for (int i = 1; i < j2; ++i) {
                if (counters != null && counters.size() > 0 && !counters.contains(columns[i])) continue;
                Element stat = values.addElement("stat");
                stat.addAttribute("name", columns[i]);
                if (data[i] == null) continue;
                stat.addAttribute("value", data[i]);
            }
        }
    }

    static void populateResponseData(Element response, Set<String> counters, String group, Iterator<String> results) throws ServiceException {
        Element host = null;
        Element stats = null;
        String[] columns = null;
        boolean needColumns = false;
        while (results.hasNext()) {
            String line = results.next();
            if ("".equals(line.trim())) continue;
            if (line.startsWith("Host: ")) {
                String hostname = line.substring(line.indexOf(" ") + 1);
                host = response.addElement("hostname");
                host.addAttribute("hn", hostname);
                stats = host.addElement("stats");
                stats.addAttribute("name", group);
                needColumns = true;
                continue;
            }
            if (needColumns) {
                columns = SPLIT_PATTERN.split(line);
                needColumns = false;
                continue;
            }
            String[] data = SPLIT_PATTERN.split(line);
            boolean rowHasData = false;
            int j = data.length;
            for (int i = 1; i < j; ++i) {
                rowHasData = rowHasData || data[i] != null && !data[i].trim().equals("");
            }
            if (!rowHasData) continue;
            Element values = stats.addElement("values");
            values.addAttribute("t", data[0]);
            int j2 = data.length;
            for (int i = 1; i < j2; ++i) {
                if (counters != null && counters.size() > 0 && !counters.contains(columns[i])) continue;
                Element stat = values.addElement("stat");
                stat.addAttribute("name", columns[i]);
                if (data[i] == null) continue;
                stat.addAttribute("value", data[i]);
            }
        }
    }

    static Iterator<String> execfetch(String ... args) throws ServiceException {
        BufferedReader in = null;
        try {
            final Socket socket = new Socket(InetAddress.getByName(null), LC.logger_zmrrdfetch_port.intValue());
            final PrintWriter out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), "utf-8"));
            StringBuilder cmdline = new StringBuilder();
            for (String arg : args) {
                cmdline.append(arg).append(" ");
            }
            cmdline.setLength(cmdline.length() - 1);
            out.println(cmdline.toString());
            out.flush();
            final BufferedReader inbr = in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            return new Iterator<String>(){
                String line;
                boolean isClosed = false;

                @Override
                public boolean hasNext() {
                    try {
                        this.line = inbr.readLine();
                    }
                    catch (IOException e) {
                        ZimbraLog.soap.error((Object)"GetLoggerStats IOE", e);
                        this.line = null;
                    }
                    if (this.line == null) {
                        try {
                            out.close();
                            inbr.close();
                            socket.close();
                            this.isClosed = true;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return this.line != null;
                }

                @Override
                public String next() {
                    if (!this.isClosed && this.line == null) {
                        try {
                            inbr.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw new IllegalStateException("hasNext not called");
                    }
                    if (this.isClosed) {
                        throw new IllegalStateException("no more results");
                    }
                    String l = this.line;
                    this.line = null;
                    return l;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Unable to read logger stats", e);
        }
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Only system admins are allowed.");
    }
}

