/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.RightCommand;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.service.admin.RightDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetGrants
extends RightDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetGrants.getZimbraSoapContext(context);
        String targetType = null;
        Provisioning.TargetBy targetBy = null;
        String target = null;
        Element eTarget = request.getOptionalElement("target");
        if (eTarget != null && TargetType.fromCode(targetType = eTarget.getAttribute("type")).needsTargetIdentity()) {
            targetBy = Provisioning.TargetBy.fromString(eTarget.getAttribute("by"));
            target = eTarget.getText();
        }
        String granteeType = null;
        Provisioning.GranteeBy granteeBy = null;
        String grantee = null;
        boolean granteeIncludeGroupsGranteeBelongs = true;
        Element eGrantee = request.getOptionalElement("grantee");
        if (eGrantee != null) {
            granteeType = eGrantee.getAttribute("type");
            granteeBy = Provisioning.GranteeBy.fromString(eGrantee.getAttribute("by"));
            grantee = eGrantee.getText();
            granteeIncludeGroupsGranteeBelongs = eGrantee.getAttributeBool("all");
        }
        Provisioning prov = Provisioning.getInstance();
        RightCommand.Grants grants = RightCommand.getGrants(prov, targetType, targetBy, target, granteeType, granteeBy, grantee, granteeIncludeGroupsGranteeBelongs);
        HashSet<String> OKedTarget = new HashSet<String>();
        for (RightCommand.ACE ace : grants.getACEs()) {
            TargetType tt = TargetType.fromCode(ace.targetType());
            Entry targetEntry = TargetType.lookupTarget(prov, tt, Provisioning.TargetBy.name, ace.targetName());
            String targetKey = ace.targetType() + "-" + ace.targetId();
            if (OKedTarget.contains(targetKey)) continue;
            GetGrants.checkRight(zsc, targetEntry, Rights.Admin.R_viewGrants);
            OKedTarget.add(targetKey);
        }
        Element resp = zsc.createElement(AdminConstants.GET_GRANTS_RESPONSE);
        grants.toXML(resp);
        return resp;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_viewGrants);
        notes.add("Needs a get attr right of zimbraACE on each the target entry.  Granting the " + Rights.Admin.R_viewGrants.getName() + " is one way to do it, " + "which will give the right on all target types.   Use inline right " + "if more granularity is needed.   See doc for the " + Rights.Admin.R_viewGrants.getName() + " right in zimbra-rights.xml for more details.");
    }
}

