/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.fb.FreeBusyProvider;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetFreeBusyQueueInfo
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetFreeBusyQueueInfo.getZimbraSoapContext(context);
        this.checkRight(zsc, context, null, AdminRight.PR_SYSTEM_ADMIN_ONLY);
        String name = null;
        Element provider = request.getOptionalElement("provider");
        if (provider != null) {
            name = provider.getAttribute("name");
        }
        Element response = zsc.createElement(AdminConstants.GET_FREE_BUSY_QUEUE_INFO_RESPONSE);
        if (name != null) {
            FreeBusyProvider prov = FreeBusyProvider.getProvider(name);
            if (prov == null) {
                throw ServiceException.INVALID_REQUEST("provider not found: " + name, null);
            }
            this.handleProvider(response, prov);
        } else {
            for (FreeBusyProvider prov : FreeBusyProvider.getProviders()) {
                this.handleProvider(response, prov);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProvider(Element response, FreeBusyProvider prov) {
        Element provider = response.addElement("provider");
        provider.addAttribute("name", prov.getName());
        FreeBusyProvider.FreeBusySyncQueue queue = prov.getSyncQueue();
        if (queue == null) {
            return;
        }
        FreeBusyProvider.FreeBusySyncQueue freeBusySyncQueue = queue;
        synchronized (freeBusySyncQueue) {
            for (String id : queue) {
                provider.addElement("account").addAttribute("id", id);
            }
        }
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Only system admins are allowed.");
    }
}

