/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.RightCommand;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.service.admin.RightDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetEffectiveRights
extends RightDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String grantee;
        Provisioning.GranteeBy granteeBy;
        Element eGrantee;
        ZimbraSoapContext zsc = GetEffectiveRights.getZimbraSoapContext(context);
        Pair<Boolean, Boolean> expandAttrs = this.parseExpandAttrs(request);
        boolean expandSetAttrs = expandAttrs.getFirst();
        boolean expandGetAttrs = expandAttrs.getSecond();
        Element eTarget = request.getElement("target");
        String targetType = eTarget.getAttribute("type");
        Provisioning.TargetBy targetBy = null;
        String target = null;
        if (TargetType.fromCode(targetType).needsTargetIdentity()) {
            targetBy = Provisioning.TargetBy.fromString(eTarget.getAttribute("by"));
            target = eTarget.getText();
        }
        if ((eGrantee = request.getOptionalElement("grantee")) != null) {
            String granteeType = eGrantee.getAttribute("type", GranteeType.GT_USER.getCode());
            if (GranteeType.fromCode(granteeType) != GranteeType.GT_USER) {
                throw ServiceException.INVALID_REQUEST("invalid grantee type " + granteeType, null);
            }
            granteeBy = Provisioning.GranteeBy.fromString(eGrantee.getAttribute("by"));
            grantee = eGrantee.getText();
        } else {
            granteeBy = Provisioning.GranteeBy.id;
            grantee = zsc.getRequestedAccountId();
        }
        if (!grantee.equals(zsc.getAuthtokenAccountId())) {
            this.checkCheckRightRight(zsc, GranteeType.GT_USER, granteeBy, grantee);
        }
        RightCommand.EffectiveRights er = RightCommand.getEffectiveRights(Provisioning.getInstance(), targetType, targetBy, target, granteeBy, grantee, expandSetAttrs, expandGetAttrs);
        Element resp = zsc.createElement(AdminConstants.GET_EFFECTIVE_RIGHTS_RESPONSE);
        er.toXML_getEffectiveRights(resp);
        return resp;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_checkRightUsr);
    }
}

