/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AttributeFlag;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetDomainInfo
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext lc = GetDomainInfo.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        boolean applyConfig = request.getAttributeBool("applyConfig", true);
        Element d = request.getElement("domain");
        String key = d.getAttribute("by");
        String value = d.getText();
        Provisioning.DomainBy domainBy = Provisioning.DomainBy.fromString(key);
        Domain domain = prov.get(domainBy, value);
        Element response = lc.createElement(AdminConstants.GET_DOMAIN_INFO_RESPONSE);
        if (domain == null && domainBy != Provisioning.DomainBy.name && domainBy != Provisioning.DomainBy.virtualHostname) {
            this.toXML(response, prov.getConfig(), applyConfig);
        } else {
            if (domain == null) {
                if (domainBy == Provisioning.DomainBy.virtualHostname) {
                    domain = prov.get(Provisioning.DomainBy.name, value);
                }
                if (domain == null) {
                    domain = GetDomainInfo.findDomain(prov, value);
                }
            }
            if (domain != null) {
                this.toXML(response, domain, applyConfig);
            } else {
                this.toXML(response, prov.getConfig(), applyConfig);
            }
        }
        return response;
    }

    private void toXML(Element e, Entry entry, boolean applyConfig) throws ServiceException {
        Element domain = e.addElement("domain");
        if (entry instanceof Domain) {
            Domain d = (Domain)entry;
            domain.addAttribute("name", d.getUnicodeName());
            domain.addAttribute("id", d.getId());
        } else {
            domain.addAttribute("name", "globalconfig");
            domain.addAttribute("id", "globalconfig-dummy-id");
        }
        Set<String> attrList = AttributeManager.getInstance().getAttrsWithFlag(AttributeFlag.domainInfo);
        Map<String, Object> attrsMap = entry.getUnicodeAttrs(applyConfig);
        for (String name : attrList) {
            Object value = attrsMap.get(name);
            if (value instanceof String[]) {
                String[] sv = (String[])value;
                for (int i = 0; i < sv.length; ++i) {
                    domain.addElement("a").addAttribute("n", name).setText(sv[i]);
                }
                continue;
            }
            if (!(value instanceof String)) continue;
            domain.addElement("a").addAttribute("n", name).setText((String)value);
        }
    }

    private static Domain findDomain(Provisioning prov, String value) throws ServiceException {
        int secondDotAt;
        Domain domain = null;
        int firstDotAt = value.indexOf(46);
        int n = secondDotAt = firstDotAt == -1 ? -1 : value.indexOf(46, firstDotAt + 1);
        while (secondDotAt != -1 && (domain = prov.get(Provisioning.DomainBy.name, value.substring(firstDotAt + 1))) == null) {
            firstDotAt = secondDotAt;
            secondDotAt = value.indexOf(46, firstDotAt + 1);
        }
        return domain;
    }

    @Override
    public boolean needsAuth(Map<String, Object> context) {
        return false;
    }

    @Override
    public boolean needsAdminAuth(Map<String, Object> context) {
        return false;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Do not need any right, all admins are allowed.");
    }

    public static void main(String[] args) throws ServiceException {
        GetDomainInfo.findDomain(Provisioning.getInstance(), "x.y.z.a.b.c");
        System.out.println();
    }
}

