/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetDomain
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetDomain.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        boolean applyConfig = request.getAttributeBool("applyConfig", true);
        Set<String> reqAttrs = this.getReqAttrs(request, AttributeClass.domain);
        Element d = request.getElement("domain");
        String key = d.getAttribute("by");
        String value = d.getText();
        Domain domain = prov.get(Provisioning.DomainBy.fromString(key), value);
        if (domain == null) {
            throw AccountServiceException.NO_SUCH_DOMAIN(value);
        }
        AdminAccessControl aac = this.checkDomainRight(zsc, domain, (Object)AdminRight.PR_ALWAYS_ALLOW);
        Element response = zsc.createElement(AdminConstants.GET_DOMAIN_RESPONSE);
        GetDomain.encodeDomain(response, domain, applyConfig, reqAttrs, aac.getAttrRightChecker(domain));
        return response;
    }

    public static void encodeDomain(Element e, Domain d) throws ServiceException {
        GetDomain.encodeDomain(e, d, true);
    }

    public static void encodeDomain(Element e, Domain d, boolean applyConfig) throws ServiceException {
        GetDomain.encodeDomain(e, d, applyConfig, null, null);
    }

    public static void encodeDomain(Element e, Domain d, boolean applyConfig, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) throws ServiceException {
        Element domain = e.addElement("domain");
        domain.addAttribute("name", d.getUnicodeName());
        domain.addAttribute("id", d.getId());
        Map<String, Object> attrs = d.getUnicodeAttrs(applyConfig);
        ToXML.encodeAttrs(domain, attrs, reqAttrs, attrRightChecker);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getDomain);
        notes.add(String.format("Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.To allow an admin to get all attributes, grant the %s right", Rights.Admin.R_getDomain.getName()));
    }
}

