/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetDistributionListMembership
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext lc = GetDistributionListMembership.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        int limit = (int)request.getAttributeLong("limit", 0L);
        if (limit < 0) {
            throw ServiceException.INVALID_REQUEST("limit" + limit + " is negative", null);
        }
        int offset = (int)request.getAttributeLong("offset", 0L);
        if (offset < 0) {
            throw ServiceException.INVALID_REQUEST("offset" + offset + " is negative", null);
        }
        Element d = request.getElement("dl");
        String key = d.getAttribute("by");
        String value = d.getText();
        DistributionList distributionList = prov.get(Provisioning.DistributionListBy.fromString(key), value);
        if (distributionList == null) {
            throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(value);
        }
        this.checkDistributionListRight(lc, distributionList, Rights.Admin.R_getDistributionListMembership);
        HashMap<String, String> via = new HashMap<String, String>();
        List<DistributionList> lists = prov.getDistributionLists(distributionList, false, via);
        Element response = lc.createElement(AdminConstants.GET_DISTRIBUTION_LIST_MEMBERSHIP_RESPONSE);
        for (DistributionList dl : lists) {
            Element dlEl = response.addElement("dl");
            dlEl.addAttribute("name", dl.getName());
            dlEl.addAttribute("id", dl.getId());
            String viaDl = via.get(dl.getName());
            if (viaDl == null) continue;
            dlEl.addAttribute("via", viaDl);
        }
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getDistributionListMembership);
    }
}

