/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.service.admin.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetDistributionList
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        boolean allowMembers;
        ZimbraSoapContext zsc = GetDistributionList.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        int limit = (int)request.getAttributeLong("limit", 0L);
        if (limit < 0) {
            throw ServiceException.INVALID_REQUEST("limit" + limit + " is negative", null);
        }
        int offset = (int)request.getAttributeLong("offset", 0L);
        if (offset < 0) {
            throw ServiceException.INVALID_REQUEST("offset" + offset + " is negative", null);
        }
        boolean sortAscending = request.getAttributeBool("sortAscending", true);
        Set<String> reqAttrs = this.getReqAttrs(request, AttributeClass.distributionList);
        Element d = request.getElement("dl");
        String key = d.getAttribute("by");
        String value = d.getText();
        DistributionList distributionList = prov.get(Provisioning.DistributionListBy.fromString(key), value);
        if (distributionList == null) {
            throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(value);
        }
        AdminAccessControl aac = this.checkDistributionListRight(zsc, distributionList, AdminRight.PR_ALWAYS_ALLOW);
        AccessManager.AttrRightChecker arc = aac.getAttrRightChecker(distributionList);
        Element response = zsc.createElement(AdminConstants.GET_DISTRIBUTION_LIST_RESPONSE);
        Element dlElement = GetDistributionList.encodeDistributionList(response, distributionList, true, reqAttrs, arc);
        boolean bl = allowMembers = arc == null ? true : arc.allowAttr("zimbraMailForwardingAddress");
        if (allowMembers) {
            this.encodeMembers(response, dlElement, distributionList, offset, limit, sortAscending);
        }
        return response;
    }

    private void encodeMembers(Element response, Element dlElement, DistributionList distributionList, int offset, int limit, boolean sortAscending) throws ServiceException {
        Object[] members = distributionList.getAllMembers();
        if (offset > 0 && offset >= members.length) {
            throw ServiceException.INVALID_REQUEST("offset " + offset + " greater than size " + members.length, null);
        }
        int stop = offset + limit;
        if (limit == 0) {
            stop = members.length;
        }
        if (stop > members.length) {
            stop = members.length;
        }
        if (sortAscending) {
            Arrays.sort(members);
        } else {
            Arrays.sort(members, Collections.reverseOrder());
        }
        for (int i = offset; i < stop; ++i) {
            dlElement.addElement("dlm").setText((String)members[i]);
        }
        response.addAttribute("more", stop < members.length);
        response.addAttribute("total", members.length);
    }

    public static Element encodeDistributionList(Element e, DistributionList d) throws ServiceException {
        return GetDistributionList.encodeDistributionList(e, d, true, null, null);
    }

    public static Element encodeDistributionList(Element e, DistributionList d, boolean hideZMFA, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) throws ServiceException {
        Element distributionList = e.addElement("dl");
        distributionList.addAttribute("name", d.getUnicodeName());
        distributionList.addAttribute("id", d.getId());
        GetDistributionList.encodeDistributionListAttrs(distributionList, d.getUnicodeAttrs(), hideZMFA, reqAttrs, attrRightChecker);
        return distributionList;
    }

    static void encodeDistributionListAttrs(Element e, Map attrs, boolean hideZMFA, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) throws ServiceException {
        AttributeManager attrMgr = AttributeManager.getInstance();
        for (Map.Entry entry : attrs.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (hideZMFA && name.equals("zimbraMailForwardingAddress") || reqAttrs != null && !reqAttrs.contains(name)) continue;
            boolean allowed = attrRightChecker == null ? true : attrRightChecker.allowAttr(name);
            AttributeManager.IDNType idnType = AttributeManager.idnType(attrMgr, name);
            if (value instanceof String[]) {
                String[] sv = (String[])value;
                for (int i = 0; i < sv.length; ++i) {
                    ToXML.encodeAttr(e, name, sv[i], "a", "n", idnType, allowed);
                }
                continue;
            }
            if (!(value instanceof String)) continue;
            ToXML.encodeAttr(e, name, (String)value, "a", "n", idnType, allowed);
        }
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getDistributionList);
        notes.add(String.format("Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.To allow an admin to get all attributes, grant the %s right", Rights.Admin.R_getDistributionList.getName()));
    }
}

