/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.AttributeConstraint;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetDelegatedAdminConstraints
extends AdminDocumentHandler {
    private static final String CONSTRAINT_ATTR = "zimbraConstraint";

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Element eAttr;
        AttributeConstraint ac;
        String attrName;
        ZimbraSoapContext zsc = GetDelegatedAdminConstraints.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Entry entry = GetDelegatedAdminConstraints.getEntry(request);
        AdminAccessControl.GetAttrsRight gar = new AdminAccessControl.GetAttrsRight();
        gar.addAttr(CONSTRAINT_ATTR);
        this.checkRight(zsc, context, entry, gar);
        Map<String, AttributeConstraint> constraints = AttributeConstraint.getConstraint(entry);
        Element response = zsc.createElement(AdminConstants.GET_DELEGATED_ADMIN_CONSTRAINTS_RESPONSE);
        boolean hasRequestedAttrs = false;
        for (Element element : request.listElements("a")) {
            hasRequestedAttrs = true;
            attrName = element.getAttribute("name");
            ac = constraints.get(attrName);
            if (ac == null) continue;
            eAttr = response.addElement("a").addAttribute("name", attrName);
            ac.toXML(eAttr);
        }
        if (!hasRequestedAttrs) {
            for (Map.Entry entry2 : constraints.entrySet()) {
                attrName = (String)entry2.getKey();
                ac = (AttributeConstraint)entry2.getValue();
                eAttr = response.addElement("a").addAttribute("name", attrName);
                ac.toXML(eAttr);
            }
        }
        return response;
    }

    static Entry getEntry(Element request) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        String typeStr = request.getAttribute("type");
        TargetType type = TargetType.fromCode(typeStr);
        if (type == TargetType.config) {
            if (request.getAttribute("id", null) != null) {
                throw ServiceException.INVALID_REQUEST("cannot specify id for type " + typeStr, null);
            }
            if (request.getAttribute("name", null) != null) {
                throw ServiceException.INVALID_REQUEST("cannot specify name for type " + typeStr, null);
            }
            return prov.getConfig();
        }
        if (type == TargetType.cos) {
            String id = request.getAttribute("id", null);
            String name = request.getAttribute("name", null);
            if (id != null) {
                Cos cos = prov.get(Provisioning.CosBy.id, id);
                if (cos == null) {
                    throw AccountServiceException.NO_SUCH_COS(id);
                }
                if (name != null && !name.equals(cos.getName())) {
                    throw ServiceException.INVALID_REQUEST("Specified name " + name + " does not match entry name for the specified id " + id, null);
                }
                return cos;
            }
            if (name != null) {
                Cos cos = prov.get(Provisioning.CosBy.name, name);
                if (cos == null) {
                    throw AccountServiceException.NO_SUCH_COS(name);
                }
                if (id != null && !id.equals(cos.getId())) {
                    throw ServiceException.INVALID_REQUEST("Specified id " + id + " does not match id for the specified name " + name, null);
                }
                return cos;
            }
            throw ServiceException.INVALID_REQUEST("neither id or name is specified", null);
        }
        throw ServiceException.INVALID_REQUEST("invalid type " + typeStr, null);
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        notes.add("Need set attr right on attribute zimbraConstraint");
    }
}

