/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.cs.store.file.Volume;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCurrentVolumes
extends AdminDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext lc = GetCurrentVolumes.getZimbraSoapContext(context);
        Server localServer = Provisioning.getInstance().getLocalServer();
        this.checkRight(lc, context, localServer, Rights.Admin.R_manageVolume);
        Element response = lc.createElement(AdminConstants.GET_CURRENT_VOLUMES_RESPONSE);
        Volume msgVol = Volume.getCurrentMessageVolume();
        response.addElement("volume").addAttribute("type", 1L).addAttribute("id", msgVol.getId());
        Volume secondaryMsgVol = Volume.getCurrentSecondaryMessageVolume();
        if (secondaryMsgVol != null) {
            response.addElement("volume").addAttribute("type", 2L).addAttribute("id", secondaryMsgVol.getId());
        }
        Volume indexVol = Volume.getCurrentIndexVolume();
        response.addElement("volume").addAttribute("type", 10L).addAttribute("id", indexVol.getId());
        return response;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_manageVolume);
    }
}

