/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.RightCommand;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.admin.RightDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCreateObjectAttrs
extends RightDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetCreateObjectAttrs.getZimbraSoapContext(context);
        Element eTarget = request.getElement("target");
        String targetType = eTarget.getAttribute("type");
        Provisioning.DomainBy domainBy = null;
        String domain = null;
        Element eDomain = request.getOptionalElement("domain");
        if (eDomain != null) {
            domainBy = Provisioning.DomainBy.fromString(eDomain.getAttribute("by"));
            domain = eDomain.getText();
        }
        Provisioning.CosBy cosBy = null;
        String cos = null;
        Element eCos = request.getOptionalElement("cos");
        if (eCos != null) {
            cosBy = Provisioning.CosBy.fromString(eCos.getAttribute("by"));
            cos = eCos.getText();
        }
        Provisioning.GranteeBy granteeBy = Provisioning.GranteeBy.id;
        String grantee = zsc.getRequestedAccountId();
        if (!grantee.equals(zsc.getAuthtokenAccountId())) {
            this.checkCheckRightRight(zsc, GranteeType.GT_USER, granteeBy, grantee);
        }
        RightCommand.EffectiveRights er = RightCommand.getCreateObjectAttrs(Provisioning.getInstance(), targetType, domainBy, domain, cosBy, cos, granteeBy, grantee);
        Element resp = zsc.createElement(AdminConstants.GET_CREATE_OBJECT_ATTRS_RESPONSE);
        er.toXML_getCreateObjectAttrs(resp);
        return resp;
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_checkRightUsr);
    }
}

