/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.admin;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.service.account.ToXML;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.service.admin.AdminDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCos
extends AdminDocumentHandler {
    public boolean domainAuthSufficient(Map context) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetCos.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Set<String> reqAttrs = this.getReqAttrs(request, AttributeClass.cos);
        Element d = request.getElement("cos");
        String key = d.getAttribute("by");
        String value = d.getText();
        Cos cos = prov.get(Provisioning.CosBy.fromString(key), value);
        if (cos == null) {
            throw AccountServiceException.NO_SUCH_COS(value);
        }
        AdminAccessControl aac = this.checkCosRight(zsc, cos, AdminRight.PR_ALWAYS_ALLOW);
        Element response = zsc.createElement(AdminConstants.GET_COS_RESPONSE);
        GetCos.encodeCos(response, cos, reqAttrs, aac.getAttrRightChecker(cos));
        return response;
    }

    public static void encodeCos(Element e, Cos c) throws ServiceException {
        GetCos.encodeCos(e, c, null, null);
    }

    public static void encodeCos(Element e, Cos c, Set<String> reqAttrs, AccessManager.AttrRightChecker attrRightChecker) throws ServiceException {
        Config config = Provisioning.getInstance().getConfig();
        Element cos = e.addElement("cos");
        cos.addAttribute("name", c.getName());
        cos.addAttribute("id", c.getId());
        if (c.isDefaultCos()) {
            cos.addAttribute("isDefaultCos", true);
        }
        Map<String, Object> attrs = c.getUnicodeAttrs();
        AttributeManager attrMgr = AttributeManager.getInstance();
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            boolean isCosAttr;
            String name = entry.getKey();
            Object value = entry.getValue();
            if (reqAttrs != null && !reqAttrs.contains(name)) continue;
            boolean allowed = attrRightChecker == null ? true : attrRightChecker.allowAttr(name);
            boolean bl = isCosAttr = !attrMgr.isAccountInherited(name);
            if (value instanceof String[]) {
                String[] sv = (String[])value;
                for (int i = 0; i < sv.length; ++i) {
                    GetCos.encodeCosAttr(cos, name, sv[i], isCosAttr, allowed);
                }
                continue;
            }
            if (!(value instanceof String)) continue;
            value = ToXML.fixupZimbraPrefTimeZoneId(name, (String)value);
            GetCos.encodeCosAttr(cos, name, (String)value, isCosAttr, allowed);
        }
    }

    private static void encodeCosAttr(Element parent, String key, String value, boolean isCosAttr, boolean allowed) {
        Element e = parent.addElement("a");
        e.addAttribute("n", key);
        if (allowed) {
            e.setText(value);
        } else {
            e.addAttribute("pd", true);
        }
        if (isCosAttr) {
            e.addAttribute("c", true);
        }
    }

    @Override
    public void docRights(List<AdminRight> relatedRights, List<String> notes) {
        relatedRights.add(Rights.Admin.R_getCos);
        notes.add(String.format("Attributes that are not allowed to be get by the authenticated admin will be returned as <a n=\"{attr-name}\" pd=\"1\"/>.To allow an admin to get all attributes, grant the %s right", Rights.Admin.R_getCos.getName()));
    }
}

